/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.core.AbstractExplorer;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.core.ITransitionExecutor;
import obp.explorer.runtime.core.Transition;
import obp.explorer.runtime.obs.AtomicAction;

public class ExploringTransitionExecutor
implements ITransitionExecutor {
    protected AbstractExplorer explorer;
    protected final List<Transition> outputs = new ArrayList<Transition>();
    protected final List<Transition> inputs = new ArrayList<Transition>();
    protected final Set<IntermediateState> known = new HashSet<IntermediateState>();
    protected Queue<IntermediateState> currentToSee = new LinkedList<IntermediateState>();
    protected Queue<IntermediateState> nextToSee = new LinkedList<IntermediateState>();
    protected boolean[] noFiredInputs;
    protected boolean[] noFiredOutputs;
    private boolean[] modifiedBehaviors;

    @Override
    public void setExplorer(AbstractExplorer explorer) {
        this.explorer = explorer;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ExploringTransitionExecutor theClone = (ExploringTransitionExecutor)super.clone();
        theClone.setExplorer(null);
        return theClone;
    }

    @Override
    public void addInput(Transition transition) {
        this.inputs.add(transition);
    }

    @Override
    public void addOutput(Transition transition) {
        if (!this.outputs.contains(transition)) {
            this.outputs.add(transition);
        }
    }

    @Override
    public void init() {
        this.modifiedBehaviors = new boolean[this.explorer.getBehaviorCount()];
    }

    protected void reset() {
        this.inputs.clear();
        this.outputs.clear();
        this.known.clear();
        this.currentToSee.clear();
        this.nextToSee.clear();
    }

    protected void initExploration(Configuration source) {
        this.noFiredInputs = new boolean[this.inputs.size()];
        Arrays.fill(this.noFiredInputs, false);
        this.noFiredOutputs = new boolean[this.outputs.size()];
        Arrays.fill(this.noFiredOutputs, false);
        IntermediateState initialState = new IntermediateState();
        initialState.conf = source;
        initialState.outputPhase = true;
        initialState.firedTransitions = this.noFiredOutputs;
        initialState.actionSet = Collections.emptySet();
        initialState.canonize();
        this.known.add(initialState);
        this.currentToSee.add(initialState);
    }

    protected IntermediateState nextIntermediateState() {
        if (this.currentToSee.isEmpty()) {
            Queue<IntermediateState> tmp = this.currentToSee;
            this.currentToSee = this.nextToSee;
            this.nextToSee = tmp;
        }
        return this.currentToSee.remove();
    }

    protected void explorationStep() {
        IntermediateState currentState = this.nextIntermediateState();
        List<Transition> transitionPool = currentState.outputPhase ? this.outputs : this.inputs;
        for (int i = 0; i < transitionPool.size(); ++i) {
            ArrayList<AtomicAction> atomicActionList;
            if (currentState.firedTransitions[i]) continue;
            Configuration targetConf = new Configuration(currentState.conf);
            Transition transition = transitionPool.get(i);
            if (!this.computeTargetAndFillActionList(currentState.conf, targetConf, transition, atomicActionList = new ArrayList<AtomicAction>())) break;
            HashSet<AtomicAction> actionSet = new HashSet<AtomicAction>(currentState.actionSet);
            actionSet.addAll(atomicActionList);
            IntermediateState newState = new IntermediateState();
            newState.conf = targetConf;
            newState.outputPhase = currentState.outputPhase;
            newState.firedTransitions = new boolean[currentState.firedTransitions.length];
            System.arraycopy(currentState.firedTransitions, 0, newState.firedTransitions, 0, currentState.firedTransitions.length);
            newState.firedTransitions[i] = true;
            newState.actionSet = actionSet;
            newState.canonize();
            if (!this.known.add(newState) || newState.isFinal()) continue;
            this.nextToSee.add(newState);
        }
        if (this.currentToSee.isEmpty() && !this.nextToSee.isEmpty()) {
            this.known.clear();
        }
    }

    protected boolean hasNext() {
        return !this.currentToSee.isEmpty() || !this.nextToSee.isEmpty();
    }

    protected Configuration checkTimeBounds(Configuration source, Channel channel) {
        if (source.dbm != null && channel != null && channel.clockId != -1) {
            Configuration checkedSource = new Configuration(source);
            DBM.andGuard(checkedSource.dbm, 0, channel.clockId, channel.minBoundInternal);
            for (Transition output : this.outputs) {
                output.when(checkedSource, this.explorer);
            }
            for (Transition input : this.inputs) {
                input.when(checkedSource, this.explorer);
            }
            if (DBM.isEmpty(checkedSource.dbm)) {
                return null;
            }
            return checkedSource;
        }
        return source;
    }

    @Override
    public boolean execute(Configuration source, Channel channel) {
        Configuration checkedSource = this.checkTimeBounds(source, channel);
        if (checkedSource == null) {
            this.reset();
            return false;
        }
        this.initExploration(checkedSource);
        while (this.hasNext()) {
            this.explorationStep();
        }
        boolean result = false;
        for (IntermediateState state : this.known) {
            if (!state.isFinal()) continue;
            ArrayList<AtomicAction> atomicActionList = new ArrayList<AtomicAction>(state.actionSet);
            boolean stop = this.explorer.observe(source, atomicActionList, state.conf);
            if (state.conf.dbm != null) {
                this.explorer.applyDelayAndInvariant(source, state.conf);
            }
            if (!stop) {
                this.explorer.registerActionAndTarget(source, atomicActionList, state.conf);
            }
            result = true;
        }
        this.reset();
        return result;
    }

    @Override
    public boolean executeAlone(Configuration source, Transition transition) {
        ArrayList<AtomicAction> atomicActionList;
        this.reset();
        Configuration target = new Configuration(source);
        if (source.dbm != null) {
            transition.when(target, this.explorer);
            if (DBM.isEmpty(target.dbm)) {
                return false;
            }
        }
        if (this.computeTargetAndFillActionList(source, target, transition, atomicActionList = new ArrayList<AtomicAction>(5))) {
            if (!this.explorer.observe(source, atomicActionList, target)) {
                if (target.dbm != null) {
                    this.explorer.applyDelayAndInvariant(source, target);
                }
                this.explorer.registerActionAndTarget(source, atomicActionList, target);
            }
            return true;
        }
        return false;
    }

    protected boolean computeTargetAndFillActionList(Configuration source, Configuration target, Transition transition, List<AtomicAction> atomicActionList) {
        Arrays.fill(this.modifiedBehaviors, false);
        this.modifiedBehaviors[transition.behaviorId] = true;
        transition.updateModifiedBehaviors(target, this.explorer, this.modifiedBehaviors);
        for (short i = 0; i < this.modifiedBehaviors.length; i = (short)(i + 1)) {
            if (!this.modifiedBehaviors[i]) continue;
            target.replaceBehaviorConfigurationByCopy(i);
        }
        return transition.action(this.explorer, atomicActionList, target);
    }

    protected class IntermediateState {
        public Configuration conf;
        public boolean outputPhase;
        public boolean[] firedTransitions;
        public Set<AtomicAction> actionSet;

        protected IntermediateState() {
        }

        public boolean hasNextForPhase() {
            for (int i = 0; i < this.firedTransitions.length; ++i) {
                if (this.firedTransitions[i]) continue;
                return true;
            }
            return false;
        }

        public void canonize() {
            if (this.outputPhase && !this.hasNextForPhase()) {
                this.outputPhase = false;
                this.firedTransitions = ExploringTransitionExecutor.this.noFiredInputs;
            }
        }

        public boolean isFinal() {
            return !this.outputPhase && !this.hasNextForPhase();
        }

        public int hashCode() {
            return this.conf.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof IntermediateState)) {
                return false;
            }
            IntermediateState other = (IntermediateState)obj;
            if (this.outputPhase != other.outputPhase) {
                return false;
            }
            if (!this.conf.equals(other.conf)) {
                return false;
            }
            for (int i = 0; i < this.firedTransitions.length; ++i) {
                if (this.firedTransitions[i] == other.firedTransitions[i]) continue;
                return false;
            }
            return this.actionSet.equals(other.actionSet);
        }
    }
}

