/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.bitstate;

import announce4j.Announcer;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import obp2.algorithms.bitstate.BloomFilterN;
import obp2.core.IConfiguration;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.IExecutionController;
import obp2.core.execution.IExecutionMonitor;
import obp2.events.ExecutionEndedEvent;
import obp2.events.PropertyEvent;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ISimpleTransitionRelationIterator;
import obp2.runtime.core.ITransitionRelation;

public class BA_NestedDFS_Bitstate_Iterative<C extends IConfiguration, A>
implements IExecutionController<C, A> {
    protected final Announcer announcer = new Announcer(true);
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    ILanguageModule<?, ?, ?> languageModule;
    ISimpleTransitionRelationIterator<byte[]> simpleTransitionRelation;
    protected boolean propertyFailed = false;
    BigInteger stepCount = BigInteger.ZERO;
    protected final BloomFilterN blueKnown = new BloomFilterN();
    protected final Stack<StackEntry> blueFrontier = new Stack();
    protected BloomFilterN redKnown = new BloomFilterN();
    protected Stack<StackEntry> redFrontier = new Stack();

    public BA_NestedDFS_Bitstate_Iterative(ITransitionRelation<Object, Object, Object> runtime, IStateSpaceManager<C, A, Object> stateSpaceManager) {
        System.out.println("Running Nested-DFS Bitstate");
        this.languageModule = runtime.getModule();
        this.simpleTransitionRelation = this.languageModule.getSimpleByteArrayTransitionRelation();
    }

    public Announcer getAnnouncer() {
        return this.announcer;
    }

    public IStateSpaceManager<C, A, Object> getStateSpaceManager() {
        return null;
    }

    public BigInteger configurationCount() {
        return BigInteger.valueOf(this.blueKnown.size() + this.redKnown.size() + 1);
    }

    public BigInteger stepCount() {
        return this.stepCount;
    }

    public ITransitionRelation<C, A, Object> getRuntime() {
        return null;
    }

    public IExecutionMonitor getMonitor() {
        return this.monitor;
    }

    public void execute() {
        this.blueFrontier.push(new StackEntry(this.simpleTransitionRelation.initialIterator()));
        while (!this.blueFrontier.isEmpty()) {
            StackEntry frame = this.blueFrontier.peek();
            if (frame.hasNext()) {
                byte[] target = frame.next();
                if (this.blueKnown.add(target)) {
                    if (this.simpleTransitionRelation.isAccepting((Object)target) && this.hasLoopFrom(target)) {
                        this.announcer.announce((Object)new PropertyEvent((IExecutionController)this, false, "property", this.counterExample(target)));
                        this.propertyFailed = true;
                        break;
                    }
                    this.blueFrontier.push(new StackEntry(target, this.simpleTransitionRelation.nextIterator((Object)target)));
                }
                this.stepCount = this.stepCount.add(BigInteger.ONE);
                continue;
            }
            this.blueFrontier.pop();
        }
        if (!this.propertyFailed) {
            this.announcer.announce((Object)new PropertyEvent((IExecutionController)this, true, "property", null));
        }
        this.announcer.announce((Object)new ExecutionEndedEvent((IExecutionController)this));
    }

    boolean hasLoopFrom(byte[] acceptingState) {
        this.redKnown = new BloomFilterN();
        this.redFrontier = new Stack();
        this.redFrontier.push(new StackEntry(this.simpleTransitionRelation.nextIterator((Object)acceptingState)));
        while (!this.redFrontier.isEmpty()) {
            StackEntry frame = this.redFrontier.peek();
            if (frame.hasNext()) {
                byte[] target = frame.next();
                if (this.redKnown.add(target)) {
                    if (Arrays.equals(target, acceptingState)) {
                        return true;
                    }
                    this.redFrontier.add(new StackEntry(target, this.simpleTransitionRelation.nextIterator((Object)target)));
                }
                this.stepCount = this.stepCount.add(BigInteger.ONE);
                continue;
            }
            this.redFrontier.pop();
        }
        return false;
    }

    protected List<IConfiguration> counterExample(byte[] target) {
        ArrayList<IConfiguration> result = new ArrayList<IConfiguration>();
        result.addAll(this.blueFrontier.stream().filter(e -> e.configuration != null).map(e -> (IConfiguration)this.languageModule.getMarshaller().deserializeConfiguration(e.configuration)).collect(Collectors.toList()));
        result.add((IConfiguration)this.languageModule.getMarshaller().deserializeConfiguration(target));
        result.addAll(this.redFrontier.stream().filter(e -> e.configuration != null).map(e -> (IConfiguration)this.languageModule.getMarshaller().deserializeConfiguration(e.configuration)).collect(Collectors.toList()));
        result.add((IConfiguration)this.languageModule.getMarshaller().deserializeConfiguration(target));
        return result;
    }

    class StackEntry
    implements Iterator<byte[]> {
        byte[] configuration;
        Iterator<byte[]> neighboursIterator;

        public StackEntry(Iterator<byte[]> neighboursIterator) {
            this(null, neighboursIterator);
        }

        public StackEntry(byte[] configuration, Iterator<byte[]> neighboursIterator) {
            this.configuration = configuration;
            this.neighboursIterator = neighboursIterator;
        }

        @Override
        public boolean hasNext() {
            return this.neighboursIterator.hasNext();
        }

        @Override
        public byte[] next() {
            return this.neighboursIterator.next();
        }
    }
}

