/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import obp2.algorithms.RandomExecutions;
import obp2.core.IBuchiConfiguration;
import obp2.core.IConfiguration;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.IExecutionController;
import obp2.events.PropertyEvent;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ITransitionRelation;

public class RandomExecutionsVerification<C extends IBuchiConfiguration & IConfiguration, A>
extends RandomExecutions<C, A> {
    protected boolean verificationFinished = false;
    protected boolean verificationHolds = true;
    protected final Map<C, Integer> acceptationCountMap = new HashMap<C, Integer>();
    protected final List<C> currentTrace = new ArrayList<C>();
    protected int acceptationCount;

    public RandomExecutionsVerification(ILanguageModule<C, A, Object> languageModule) {
        super(languageModule);
    }

    public RandomExecutionsVerification(ITransitionRelation<C, A, Object> transitionRelation, IStateSpaceManager<C, A, Object> stateSpaceManager) {
        super(transitionRelation, stateSpaceManager);
    }

    @Override
    protected boolean isExecutionTerminated(C source, Collection<A> actions, Set<C> targetSet) {
        if (targetSet.isEmpty()) {
            this.verificationFinished = true;
            return true;
        }
        if (actions.size() == 1 && targetSet.size() == 1) {
            IBuchiConfiguration target = (IBuchiConfiguration)targetSet.stream().findAny().get();
            return source.equals(target);
        }
        return false;
    }

    @Override
    protected void setCurrentConfiguration(C configuration) {
        this.currentTrace.add(configuration);
        Integer previousCount = this.acceptationCountMap.get(configuration);
        if (previousCount != null) {
            if (configuration.isAccepting()) {
                this.verificationHolds = false;
            } else if (((IBuchiConfiguration)this.currentConfiguration).isAccepting()) {
                this.verificationHolds = false;
            } else if (previousCount < this.acceptationCount) {
                this.verificationHolds = false;
            }
        }
        if (configuration.isAccepting()) {
            ++this.acceptationCount;
        }
        this.acceptationCountMap.put(configuration, this.acceptationCount);
        super.setCurrentConfiguration((IConfiguration)configuration);
    }

    @Override
    protected boolean startOneExecution() {
        if (!this.verificationHolds) {
            return false;
        }
        this.acceptationCountMap.clear();
        this.currentTrace.clear();
        this.verificationFinished = false;
        this.acceptationCount = 0;
        return super.startOneExecution();
    }

    @Override
    protected boolean executeOneStep() {
        if (!this.verificationHolds) {
            return false;
        }
        return super.executeOneStep();
    }

    @Override
    protected void finishOneExecution() {
        if (((IBuchiConfiguration)this.currentConfiguration).isAccepting() && !this.verificationFinished) {
            this.verificationHolds = false;
        }
        super.finishOneExecution();
    }

    @Override
    public void execute() {
        super.execute();
        if (!this.verificationHolds) {
            this.announcer.announce((Object)new PropertyEvent((IExecutionController)this, false, "property", this.currentTrace));
        }
    }

    @Override
    protected void updateMetrics() {
        this.depthDeadlockMap.clear();
        super.updateMetrics();
    }
}

