/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.semantics.state.utils;

import java.util.LinkedList;
import java.util.List;
import plug.bpmn2.semantics.state.BPMNRuntimeInstance;
import plug.bpmn2.semantics.state.BPMNRuntimeState;
import plug.bpmn2.semantics.state.instance.ActivityInstance;
import plug.bpmn2.semantics.state.instance.ChoreographyInstance;
import plug.bpmn2.semantics.state.instance.CollaborationInstance;
import plug.bpmn2.semantics.state.instance.FlowElementsContainerInstance;
import plug.bpmn2.semantics.state.instance.ProcessInstance;
import plug.bpmn2.semantics.state.instance.SubProcessInstance;
import plug.bpmn2.semantics.state.instance.TaskInstance;

public class BPMNRuntimeEquals {
    public static <T> boolean childrenEquals(List<T> list1, List<T> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        LinkedList<T> remaining = new LinkedList<T>(list2);
        for (T element1 : list1) {
            if (remaining.isEmpty()) {
                throw new IllegalStateException("Testing equals, remaining should never be empty before the end");
            }
            boolean foundMatch = false;
            for (Object element2 : remaining) {
                if (!element1.equals(element2)) continue;
                foundMatch = true;
                remaining.remove(element2);
                break;
            }
            if (foundMatch) continue;
            return false;
        }
        if (!remaining.isEmpty()) {
            throw new IllegalStateException("Testing equals, remaining should always end empty");
        }
        return true;
    }

    private static <T extends BPMNRuntimeInstance> boolean instanceEquals(T instance1, BPMNRuntimeInstance instance2, Class<T> clazz) {
        if (!clazz.isInstance(instance2)) {
            return false;
        }
        if (!instance1.getBaseElement().equals(instance2.getBaseElement())) {
            return false;
        }
        if (instance1 instanceof ActivityInstance) {
            ActivityInstance activity1 = (ActivityInstance)instance1;
            ActivityInstance activity2 = (ActivityInstance)instance2;
            if (!activity1.getActivityState().equals((Object)activity2.getActivityState())) {
                return false;
            }
        }
        if (instance1 instanceof FlowElementsContainerInstance) {
            FlowElementsContainerInstance flowElementsContainerInstance1 = (FlowElementsContainerInstance)instance1;
            FlowElementsContainerInstance flowElementsContainerInstance2 = (FlowElementsContainerInstance)instance2;
            if (!flowElementsContainerInstance1.getTokenSet().equals(flowElementsContainerInstance2.getTokenSet())) {
                return false;
            }
        }
        return BPMNRuntimeEquals.childrenEquals(instance1.getChildInstanceList(), instance2.getChildInstanceList());
    }

    public static boolean instanceEquals(BPMNRuntimeInstance instance1, BPMNRuntimeInstance instance2) {
        if (instance1 instanceof SubProcessInstance) {
            return BPMNRuntimeEquals.instanceEquals((SubProcessInstance)instance1, instance2, SubProcessInstance.class);
        }
        if (instance1 instanceof ChoreographyInstance) {
            return BPMNRuntimeEquals.instanceEquals((ChoreographyInstance)instance1, instance2, ChoreographyInstance.class);
        }
        if (instance1 instanceof ProcessInstance) {
            return BPMNRuntimeEquals.instanceEquals((ProcessInstance)instance1, instance2, ProcessInstance.class);
        }
        if (instance1 instanceof TaskInstance) {
            return BPMNRuntimeEquals.instanceEquals((TaskInstance)instance1, instance2, TaskInstance.class);
        }
        if (instance1 instanceof CollaborationInstance) {
            return BPMNRuntimeEquals.instanceEquals((CollaborationInstance)instance1, instance2, CollaborationInstance.class);
        }
        throw new IllegalArgumentException("Unsupported instance for equals");
    }

    public static boolean stateEquals(BPMNRuntimeState state1, BPMNRuntimeState state2) {
        return BPMNRuntimeEquals.childrenEquals(state1.getRootInstanceList(), state2.getRootInstanceList());
    }
}

