/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.semantics.state.utils;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import plug.bpmn2.semantics.state.BPMNInstanceVisitor;
import plug.bpmn2.semantics.state.BPMNRuntimeInstance;
import plug.bpmn2.semantics.state.BPMNRuntimeState;
import plug.bpmn2.semantics.state.instance.ChoreographyInstance;
import plug.bpmn2.semantics.state.instance.CollaborationInstance;
import plug.bpmn2.semantics.state.instance.FlowElementsContainerInstance;
import plug.bpmn2.semantics.state.instance.ProcessInstance;
import plug.bpmn2.semantics.state.instance.SubProcessInstance;
import plug.bpmn2.semantics.state.instance.TaskInstance;
import plug.bpmn2.semantics.state.instance.data.MessageFlowData;
import plug.bpmn2.semantics.state.instance.impl.ChoreographyInstanceImpl;
import plug.bpmn2.semantics.state.instance.impl.CollaborationInstanceImpl;
import plug.bpmn2.semantics.state.instance.impl.ProcessInstanceImpl;
import plug.bpmn2.semantics.state.instance.impl.SubProcessInstanceImpl;
import plug.bpmn2.semantics.state.instance.impl.TaskInstanceImpl;

public class BPMNRuntimeCopy
implements BPMNInstanceVisitor {
    Map<BPMNRuntimeInstance, BPMNRuntimeInstance> copyMap = new HashMap<BPMNRuntimeInstance, BPMNRuntimeInstance>();
    private LinkedList<BPMNRuntimeInstance> parentStack = new LinkedList();
    private BPMNRuntimeInstance result;

    public BPMNRuntimeState copy(BPMNRuntimeState state) {
        BPMNRuntimeState copy = new BPMNRuntimeState();
        for (BPMNRuntimeInstance instance : state.getRootInstanceList()) {
            BPMNRuntimeInstance instanceCopy = this.get(instance);
            copy.getRootInstanceList().add(instanceCopy);
        }
        for (MessageFlowData messageFlowData : state.getMessageFlowDataList()) {
            MessageFlowData messageFlowDataCopy = new MessageFlowData(messageFlowData.getBaseElement(), this.copyMap.get(messageFlowData.getSourceParent()), this.copyMap.get(messageFlowData.getTargetParent()), messageFlowData.getData());
            copy.getMessageFlowDataList().add(messageFlowDataCopy);
        }
        return copy;
    }

    private BPMNRuntimeInstance getParent() {
        if (this.parentStack.size() == 0) {
            return null;
        }
        return this.parentStack.getLast();
    }

    private FlowElementsContainerInstance getActivityParent() {
        BPMNRuntimeInstance parent = this.getParent();
        return (FlowElementsContainerInstance)parent;
    }

    public BPMNRuntimeInstance get(BPMNRuntimeInstance instance) {
        this.result = null;
        instance.acceptInstanceVisitor(this);
        this.copyMap.put(instance, this.result);
        if (this.parentStack.size() != 0) {
            throw new IllegalStateException();
        }
        return this.result;
    }

    private void visitChildren(BPMNRuntimeInstance original, BPMNRuntimeInstance copy) {
        this.parentStack.addLast(copy);
        for (BPMNRuntimeInstance childInstance : original.getChildInstanceList()) {
            childInstance.acceptInstanceVisitor(this);
            this.copyMap.put(childInstance, this.result);
            copy.getChildInstanceList().add(this.result);
        }
        this.parentStack.removeLast();
        this.result = copy;
    }

    private void copyTokens(FlowElementsContainerInstance original, FlowElementsContainerInstance copy) {
        copy.getTokenSet().addAll(original.getTokenSet());
    }

    @Override
    public void visitChoreographyInstance(ChoreographyInstance instance) {
        ChoreographyInstanceImpl instanceCopy = new ChoreographyInstanceImpl(this.getParent(), instance.getBaseElement());
        this.copyTokens(instance, instanceCopy);
        this.visitChildren(instance, instanceCopy);
    }

    @Override
    public void visitCollaborationInstance(CollaborationInstance instance) {
        CollaborationInstanceImpl instanceCopy = new CollaborationInstanceImpl(this.getParent(), instance.getBaseElement());
        this.visitChildren(instance, instanceCopy);
    }

    @Override
    public void visitProcessInstance(ProcessInstance instance) {
        ProcessInstanceImpl instanceCopy = new ProcessInstanceImpl(this.getParent(), instance.getBaseElement());
        this.copyTokens(instance, instanceCopy);
        this.visitChildren(instance, instanceCopy);
    }

    @Override
    public void visitSubProcessInstance(SubProcessInstance instance) {
        SubProcessInstanceImpl instanceCopy = new SubProcessInstanceImpl(this.getActivityParent(), instance.getBaseElement(), instance.getActivityState());
        this.copyTokens(instance, instanceCopy);
        this.visitChildren(instance, instanceCopy);
    }

    @Override
    public void visitTaskInstance(TaskInstance instance) {
        TaskInstanceImpl instanceCopy = new TaskInstanceImpl(this.getActivityParent(), instance.getBaseElement(), instance.getActivityState());
        this.visitChildren(instance, instanceCopy);
    }
}

