/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.utils;

import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowElementsContainer;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.util.Bpmn2ResourceFactoryImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class BPMN2EmfUtils {
    private static boolean setupNeeded = true;

    public static void setupIfNeeded() {
        if (setupNeeded) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("bpmn", new Bpmn2ResourceFactoryImpl());
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("bpmn2", new Bpmn2ResourceFactoryImpl());
            EPackage.Registry.INSTANCE.put((Object)"http://www.omg.org/spec/BPMN/20100524/MODEL-XMI", (Object)Bpmn2Package.eINSTANCE);
            setupNeeded = false;
        }
    }

    public static URI path2URI(String fileName) {
        return URI.createURI((String)fileName);
    }

    public static Resource getResource(URI resourceURI) {
        BPMN2EmfUtils.setupIfNeeded();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.getResource(resourceURI, true);
        return resource;
    }

    public static Resource getResource(String fileName) {
        URI uri = BPMN2EmfUtils.path2URI(fileName);
        return BPMN2EmfUtils.getResource(uri);
    }

    public static DocumentRoot getDocumentRoot(Resource resource) {
        for (EObject object : resource.getContents()) {
            if (!(object instanceof DocumentRoot)) continue;
            return (DocumentRoot)object;
        }
        throw new IllegalArgumentException("Model doesn't have a DocumentRoot");
    }

    public static DocumentRoot getDocumentRoot(String fileName) {
        return BPMN2EmfUtils.getDocumentRoot(BPMN2EmfUtils.getResource(fileName));
    }

    public static DocumentRoot getDocumentRoot(URI resourceURI) {
        return BPMN2EmfUtils.getDocumentRoot(BPMN2EmfUtils.getResource(resourceURI));
    }

    public static DocumentRoot getDocumentRoot(java.net.URI resourceURI) {
        return BPMN2EmfUtils.getDocumentRoot(URI.createURI((String)resourceURI.toString()));
    }

    public static String getFlowElementName(FlowElement flowElement) {
        String name = flowElement.getName();
        if (name == null || name.isEmpty()) {
            name = flowElement.getId();
        }
        return name.replace("\n", " ");
    }

    public static String getContainerName(FlowElement flowElement) {
        FlowElementsContainer container = (FlowElementsContainer)flowElement.eContainer();
        if (container instanceof Process) {
            return ((Process)container).getName();
        }
        if (container instanceof SubProcess) {
            return ((SubProcess)container).getName();
        }
        return container.toString();
    }
}

