/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.semantics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import obp2.bpmn2.model.action.BPMN2FlowAction;
import obp2.bpmn2.semantics.BPMN2ExecutionState;
import obp2.bpmn2.semantics.BPMN2Semantics;
import obp2.bpmn2.utils.BPMN2TokenUtils;

public class BPMN2SemanticsNaive
implements BPMN2Semantics {
    @Override
    public Set<BPMN2ExecutionState> execute(BPMN2ExecutionState source, BPMN2FlowAction flowAction) {
        int[] sourceTokens = source.tokens;
        HashSet<Integer> removeOnce = new HashSet<Integer>();
        for (int tokenToRemoveOnce : flowAction.getMandatoryTokens()) {
            removeOnce.add(tokenToRemoveOnce);
        }
        HashSet<Integer> optionalTokens = new HashSet<Integer>();
        for (int optionalToken : flowAction.getOptionalTokens()) {
            optionalTokens.add(optionalToken);
        }
        ArrayList<Integer> targetTokens = new ArrayList<Integer>();
        for (int producedToken : flowAction.getProducedTokens()) {
            targetTokens.add(producedToken);
        }
        for (int sourceToken : sourceTokens) {
            if (removeOnce.contains(sourceToken)) {
                removeOnce.remove(sourceToken);
                continue;
            }
            if (optionalTokens.contains(sourceToken)) {
                for (int optionalProducedToken : flowAction.getProducedTokens(sourceToken)) {
                    targetTokens.add(optionalProducedToken);
                }
                continue;
            }
            targetTokens.add(sourceToken);
        }
        if (removeOnce.size() != 0) {
            throw new IllegalStateException("Missing tokens");
        }
        targetTokens.sort(Integer::compareTo);
        return Collections.singleton(new BPMN2ExecutionState(BPMN2TokenUtils.toArray(targetTokens)));
    }

    @Override
    public boolean canFire(BPMN2ExecutionState state, BPMN2FlowAction flowAction) {
        int[] excludedTokens;
        int[] tokens = state.tokens;
        int[] mandatoryTokens = flowAction.getMandatoryTokens();
        if (mandatoryTokens.length == 0) {
            return false;
        }
        for (int mandatoryToken : mandatoryTokens) {
            if (BPMN2TokenUtils.hasToken(tokens, mandatoryToken)) continue;
            return false;
        }
        for (int excludedToken : excludedTokens = flowAction.getExcludedTokens()) {
            if (!BPMN2TokenUtils.hasToken(tokens, excludedToken)) continue;
            return false;
        }
        return true;
    }
}

