/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.model.token;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import obp2.bpmn2.model.token.Token;
import obp2.bpmn2.utils.BPMN2TokenUtils;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;

public class TokenPool {
    private final Token[] tokenArray;

    protected TokenPool(Collection<Token> tokenCollection) {
        this.tokenArray = new Token[tokenCollection.size()];
        int id = 0;
        for (Token token : tokenCollection) {
            token.setId(id);
            this.tokenArray[id] = token;
            ++id;
        }
    }

    public Token[] getTokenArray() {
        return this.tokenArray;
    }

    public Token getToken(int id) {
        return this.tokenArray[id];
    }

    public int[] getTokenIds(BaseElement baseElement) {
        ArrayList<Integer> tokenList = new ArrayList<Integer>();
        for (Token token : this.tokenArray) {
            if (!token.getPlaceBaseElement().equals(baseElement)) continue;
            tokenList.add(token.getId());
        }
        return BPMN2TokenUtils.toArray(tokenList);
    }

    public int[] getTokenIds(List<CallActivity> callStack) {
        ArrayList<Integer> tokenList = new ArrayList<Integer>();
        for (Token token : this.tokenArray) {
            if (!BPMN2TokenUtils.callStackEquals(callStack, token.getCallStack())) continue;
            tokenList.add(token.getId());
        }
        return BPMN2TokenUtils.toArray(tokenList);
    }

    public int getTokenId(List<CallActivity> callStack, BaseElement baseElement) {
        int[] tokenIds = this.getTokenIds(baseElement);
        int lastTokenId = -1;
        int tokenCount = 0;
        for (int tokenId : tokenIds) {
            Token token = this.getToken(tokenId);
            if (!BPMN2TokenUtils.callStackEquals(callStack, token.getCallStack())) continue;
            lastTokenId = token.getId();
            ++tokenCount;
        }
        if (tokenCount > 1) {
            throw new IllegalStateException("More than one matching token (" + tokenCount + ")");
        }
        return lastTokenId;
    }
}

