/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.extended.timed.interval;

import obp2.bpmn2.extended.timed.dbm.DBMInternals;
import obp2.bpmn2.extended.timed.dbm.DBMOps;
import obp2.bpmn2.extended.timed.interval.Interval;

public class DBMIntervals {
    private DBMIntervals() {
    }

    public static boolean checkGuard(int nbClocks, short[] dbm, int clockIndex, Interval guard) {
        short maxInternal;
        int maxValue;
        short minInternal = DBMInternals.getMinInternal(dbm, nbClocks, clockIndex);
        int minValue = -DBMInternals.getValue(minInternal);
        if (minValue > guard.getMaxValue()) {
            return false;
        }
        if (minValue == guard.getMaxValue()) {
            boolean minStrict = DBMInternals.isStrict(minInternal);
            if (!guard.isMaxIncluded() || minStrict) {
                return false;
            }
        }
        if ((maxValue = DBMInternals.getValue(maxInternal = DBMInternals.getMaxInternal(dbm, nbClocks, clockIndex))) < guard.getMinValue()) {
            return false;
        }
        if (maxValue == guard.getMinValue()) {
            boolean maxStrict = DBMInternals.isStrict(maxInternal);
            return guard.isMinIncluded() && !maxStrict;
        }
        return true;
    }

    public static void applyGuard(int nbClocks, short[] dbm, int clockIndex, Interval guard) {
        if (!guard.isMinIncluded() || guard.getMinValue() != 0) {
            DBMOps.andGuard(nbClocks, dbm, 0, clockIndex, -guard.getMinValue(), !guard.isMinIncluded());
        }
        if (guard.getMaxValue() != Integer.MAX_VALUE) {
            DBMOps.andGuard(nbClocks, dbm, clockIndex, 0, guard.getMaxValue(), !guard.isMaxIncluded());
        }
    }

    public static void applyInvariant(int nbClocks, short[] dbm, int clockIndex, Interval invariant) {
        if (!invariant.isMinIncluded() || invariant.getMinValue() != 0) {
            DBMOps.andInvariant(dbm, 0, clockIndex, -invariant.getMinValue(), !invariant.isMinIncluded());
        }
        if (invariant.getMaxValue() != Integer.MAX_VALUE) {
            DBMOps.andInvariant(dbm, clockIndex, 0, invariant.getMaxValue(), !invariant.isMaxIncluded());
        }
    }

    public static boolean checkInInterval(int nbClocks, short[] dbm, int clockIndex, Interval interval) {
        boolean minStrict;
        short minInternal = DBMInternals.getMinInternal(dbm, nbClocks, clockIndex);
        int minValue = -DBMInternals.getValue(minInternal);
        if (minValue < interval.getMinValue()) {
            return false;
        }
        if (minValue == interval.getMinValue() && !(minStrict = DBMInternals.isStrict(minInternal)) && !interval.isMinIncluded()) {
            return false;
        }
        short maxInternal = DBMInternals.getMaxInternal(dbm, nbClocks, clockIndex);
        int maxValue = DBMInternals.getValue(maxInternal);
        if (maxValue > interval.getMaxValue()) {
            return false;
        }
        if (maxValue == interval.getMaxValue()) {
            boolean maxStrict = DBMInternals.isStrict(maxInternal);
            return maxStrict || interval.isMaxIncluded();
        }
        return true;
    }
}

