/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms;

import announce4j.Announcer;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import obp2.core.IConfiguration;
import obp2.core.IFiredTransition;
import obp2.core.IStateSpaceManager;
import obp2.core.execution.IExecutionController;
import obp2.core.execution.IExecutionMonitor;
import obp2.events.ExecutionEndedEvent;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ITransitionRelation;

public class RandomExecutions<C extends IConfiguration, A>
implements IExecutionController<C, A> {
    protected final Announcer announcer = new Announcer(true);
    protected final IExecutionMonitor.Simple monitor = new IExecutionMonitor.Simple();
    protected final ILanguageModule<C, A, Object> languageModule;
    protected final Random random = new Random();
    protected final Set<C> known = new HashSet<C>();
    private final Set<C> targetSet = new HashSet<C>();
    protected C currentConfiguration;
    protected int depth;
    protected int maxDepth;
    protected static String configurationCountKey = "confs";
    protected BigInteger configurationCount = BigInteger.ZERO;
    protected static String transitionCountKey = "trans";
    protected BigInteger transitionCount = BigInteger.ZERO;
    protected static String executionCountKey = "execs";
    protected BigInteger executionCount = BigInteger.ZERO;
    protected Map<Integer, Integer> depthDeadlockMap = new LinkedHashMap<Integer, Integer>();
    protected Map<String, BigInteger> metrics = new LinkedHashMap<String, BigInteger>();

    public RandomExecutions(ILanguageModule<C, A, Object> languageModule) {
        this.languageModule = languageModule;
    }

    public RandomExecutions(ITransitionRelation<C, A, Object> transitionRelation, IStateSpaceManager<C, A, Object> stateSpaceManager) {
        this(transitionRelation.getModule());
    }

    public Announcer getAnnouncer() {
        return this.announcer;
    }

    public IStateSpaceManager<C, A, Object> getStateSpaceManager() {
        return null;
    }

    public ITransitionRelation<C, A, Object> getRuntime() {
        return this.languageModule.getTransitionRelation();
    }

    public IExecutionMonitor getMonitor() {
        return this.monitor;
    }

    protected <T> T pickRandomly(Collection<T> collection) {
        int randomIndex = this.random.nextInt(collection.size());
        Iterator<T> configurationIterator = collection.iterator();
        for (int currentIndex = 0; currentIndex < randomIndex; ++currentIndex) {
            configurationIterator.next();
        }
        return configurationIterator.next();
    }

    protected C randomInitial() {
        Set intialConfigurationSet = this.getRuntime().initialConfigurations();
        if (intialConfigurationSet.isEmpty()) {
            return null;
        }
        return (C)((IConfiguration)this.pickRandomly(intialConfigurationSet));
    }

    protected boolean isExecutionTerminated(C source, Collection<A> actions, Set<C> targetSet) {
        return targetSet.isEmpty();
    }

    protected synchronized C randomTarget(C source, boolean deep) {
        Set actions = this.getRuntime().fireableTransitionsFrom(source);
        if (!deep && !actions.isEmpty()) {
            actions = Collections.singleton(this.pickRandomly(actions));
        }
        for (Object action : actions) {
            IFiredTransition firedTransition = this.getRuntime().fireOneTransition(source, action);
            this.transitionCount = this.transitionCount.add(BigInteger.ONE);
            this.targetSet.addAll(firedTransition.getTargets());
        }
        if (this.isExecutionTerminated(source, actions, this.targetSet)) {
            return null;
        }
        IConfiguration randomTarget = (IConfiguration)this.pickRandomly(this.targetSet);
        this.targetSet.clear();
        return (C)randomTarget;
    }

    protected void setCurrentConfiguration(C configuration) {
        this.currentConfiguration = configuration;
        this.known.add(configuration);
        this.configurationCount = this.configurationCount.add(BigInteger.ONE);
    }

    protected boolean startOneExecution() {
        C initial = this.randomInitial();
        if (initial == null) {
            return false;
        }
        this.setCurrentConfiguration(initial);
        this.depth = 0;
        return true;
    }

    protected boolean executeOneStep() {
        C target = this.randomTarget(this.currentConfiguration, false);
        if (target == null) {
            return false;
        }
        ++this.depth;
        this.setCurrentConfiguration(target);
        return true;
    }

    protected void finishOneExecution() {
        if (this.depth > this.maxDepth) {
            this.maxDepth = this.depth;
            System.out.println("New max depth reached: " + this.maxDepth + ", config: " + this.currentConfiguration);
        }
        this.executionCount = this.executionCount.add(BigInteger.ONE);
        int depthDeadlockCount = this.depthDeadlockMap.computeIfAbsent(this.depth, d -> 0) + 1;
        this.depthDeadlockMap.put(this.depth, depthDeadlockCount);
    }

    public void execute() {
        this.maxDepth = 0;
        while (this.startOneExecution()) {
            while (this.executeOneStep()) {
            }
            this.finishOneExecution();
        }
        this.announcer.announce((Object)new ExecutionEndedEvent((IExecutionController)this));
    }

    public BigInteger configurationCount() {
        this.updateMetrics();
        return this.metrics.get(configurationCountKey);
    }

    public BigInteger stepCount() {
        return BigInteger.ZERO;
    }

    protected void updateMetrics() {
        this.metrics.clear();
        this.metrics.put(configurationCountKey, this.configurationCount);
        this.metrics.put("unique", BigInteger.valueOf(this.known.size()));
        this.metrics.put(transitionCountKey, this.transitionCount);
        this.metrics.put(executionCountKey, this.executionCount);
        if (this.depthDeadlockMap.keySet().size() < 2) {
            for (Map.Entry<Integer, Integer> depthDeadlockCount : this.depthDeadlockMap.entrySet()) {
                this.metrics.put("dl@depth " + depthDeadlockCount.getKey(), BigInteger.valueOf(depthDeadlockCount.getValue().intValue()));
            }
        } else {
            Iterator<Map.Entry<Integer, Integer>> iterator = this.depthDeadlockMap.entrySet().iterator();
            Map.Entry<Integer, Integer> current = iterator.next();
            int maxDepth = current.getKey();
            int maxCount = current.getValue();
            while (iterator.hasNext()) {
                current = iterator.next();
                int depth = current.getKey();
                if (depth <= maxDepth) continue;
                maxDepth = depth;
                maxCount = current.getValue();
            }
            this.metrics.put("dl@depth " + maxDepth + " (max)", BigInteger.valueOf(maxCount));
        }
    }

    public Map<String, BigInteger> metrics() {
        this.updateMetrics();
        return this.metrics;
    }
}

