/*
 * Decompiled with CFR 0.152.
 */
package obp2.operators.bytearray;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.function.Function;
import java.util.function.Supplier;
import obp2.core.registry.LanguageModuleRegistry;
import obp2.operators.bytearray.ByteArrayLanguageModule;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ILanguagePlugin;
import obp2.runtime.core.LanguageModule;

public class ByteArrayPlugin
implements ILanguagePlugin<URI, byte[], byte[], byte[]> {
    public String[] getExtensions() {
        return new String[]{".bytewrap"};
    }

    public String getName() {
        return "ByteArrayWrapper";
    }

    public static LanguageModule<byte[], byte[], byte[]> getLanguageModule(ILanguageModule<Object, Object, Object> subjectModule) {
        return new ByteArrayLanguageModule(subjectModule);
    }

    public Function<URI, ILanguageModule<byte[], byte[], byte[]>> languageModuleFunction() {
        return description -> {
            File modelFile = new File((URI)description);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(modelFile)));){
                String subjectModelURI = reader.readLine();
                Supplier supplier = LanguageModuleRegistry.getLanguageModuleSupplier((Path)Paths.get(subjectModelURI, new String[0]));
                ILanguageModule subjectModule = (ILanguageModule)supplier.get();
                LanguageModule<byte[], byte[], byte[]> languageModule = ByteArrayPlugin.getLanguageModule((ILanguageModule<Object, Object, Object>)subjectModule);
                return languageModule;
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
                return null;
            }
        };
    }
}

