@if "%DEBUG%" == "" @echo off
@rem ##########################################################################
@rem
@rem  obp2-oneway startup script for Windows
@rem
@rem ##########################################################################

@rem Set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" setlocal

set DIRNAME=%~dp0
if "%DIRNAME%" == "" set DIRNAME=.
set APP_BASE_NAME=%~n0
set APP_HOME=%DIRNAME%..

@rem Add default JVM options here. You can also use JAVA_OPTS and OBP2_ONEWAY_OPTS to pass JVM options to this script.
set DEFAULT_JVM_OPTS="-XX:+ExitOnOutOfMemoryError" "-Dapple.laf.useScreenMenuBar=true"

@rem Find java.exe
if defined JAVA_HOME goto findJavaFromJavaHome

set JAVA_EXE=java.exe
%JAVA_EXE% -version >NUL 2>&1
if "%ERRORLEVEL%" == "0" goto init

echo.
echo ERROR: JAVA_HOME is not set and no 'java' command could be found in your PATH.
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:findJavaFromJavaHome
set JAVA_HOME=%JAVA_HOME:"=%
set JAVA_EXE=%JAVA_HOME%/bin/java.exe

if exist "%JAVA_EXE%" goto init

echo.
echo ERROR: JAVA_HOME is set to an invalid directory: %JAVA_HOME%
echo.
echo Please set the JAVA_HOME variable in your environment to match the
echo location of your Java installation.

goto fail

:init
@rem Get command-line arguments, handling Windows variants

if not "%OS%" == "Windows_NT" goto win9xME_args

:win9xME_args
@rem Slurp the command line arguments.
set CMD_LINE_ARGS=
set _SKIP=2

:win9xME_args_slurp
if "x%~1" == "x" goto execute

set CMD_LINE_ARGS=%*

:execute
@rem Setup the command line

set CLASSPATH=%APP_HOME%\lib\obp2-oneway-1.0.0.jar;%APP_HOME%\lib\obp2-GUI-1.0.0-oneway.jar;%APP_HOME%\lib\obp2-CLI-1.0.0-oneway.jar;%APP_HOME%\lib\obp2-runtime-buchikripke-1.0.0.jar;%APP_HOME%\lib\obp2-runtime-buchi-1.0.0.jar;%APP_HOME%\lib\LTL-1.0.0.jar;%APP_HOME%\lib\obp2-execution-1.0.0.jar;%APP_HOME%\lib\obp2-algorithms-1.0.0.jar;%APP_HOME%\lib\obp2-hash-1.0.0.jar;%APP_HOME%\lib\obp2-runtime-remote-1.0.0.jar;%APP_HOME%\lib\obp2-bpmn2-semantics-1.0.0.jar;%APP_HOME%\lib\BuchiAutomata-1.0.0.jar;%APP_HOME%\lib\LPropositionalLogic-1.0.0.jar;%APP_HOME%\lib\org.eclipse.emf.ecore.xmi-2.16.0.jar;%APP_HOME%\lib\org.eclipse.emf.ecore-2.26.0.jar;%APP_HOME%\lib\org.eclipse.emf.common-2.24.0.jar;%APP_HOME%\lib\org.eclipse.bpmn2-1.5.1.Final-v20200903-1545.jar;%APP_HOME%\lib\obp2-utils-fx-1.0.0.jar;%APP_HOME%\lib\obp2-folding-1.0.0.jar;%APP_HOME%\lib\ikonli-javafx-2.1.1.jar;%APP_HOME%\lib\ikonli-material-pack-2.1.1.jar;%APP_HOME%\lib\ikonli-typicons-pack-2.1.1.jar;%APP_HOME%\lib\richtextfx-0.9.0.jar;%APP_HOME%\lib\flowless-0.6.1.jar;%APP_HOME%\lib\controlsfx-8.40.14.jar;%APP_HOME%\lib\args4j-2.33.jar;%APP_HOME%\lib\obp2-visualisation-1.0.0.jar;%APP_HOME%\lib\LTL3BA-1.0.0.jar;%APP_HOME%\lib\obp2-kernel-1.0.0.jar;%APP_HOME%\lib\obp2-bytearray-1.0.0.jar;%APP_HOME%\lib\obp2-runtime-1.0.0.jar;%APP_HOME%\lib\obp2-utils-1.0.0.jar;%APP_HOME%\lib\antlr4-4.5.3.jar;%APP_HOME%\lib\jackson-databind-2.12.0-rc2.jar;%APP_HOME%\lib\announce4j-1.0.jar;%APP_HOME%\lib\plug-bpmn2-examples-0.0.8.jar;%APP_HOME%\lib\commons-jexl3-3.1.jar;%APP_HOME%\lib\commons-lang3-3.8.1.jar;%APP_HOME%\lib\ikonli-core-2.1.1.jar;%APP_HOME%\lib\undofx-2.0.0.jar;%APP_HOME%\lib\reactfx-2.0-M5.jar;%APP_HOME%\lib\wellbehavedfx-0.3.3.jar;%APP_HOME%\lib\jackson-annotations-2.12.0-rc2.jar;%APP_HOME%\lib\jackson-core-2.12.0-rc2.jar;%APP_HOME%\lib\commons-logging-1.2.jar

@rem Execute obp2-oneway
"%JAVA_EXE%" %DEFAULT_JVM_OPTS% %JAVA_OPTS% %OBP2_ONEWAY_OPTS%  -classpath "%CLASSPATH%" obp2.ui2.PlugUI %CMD_LINE_ARGS%

:end
@rem End local scope for the variables with windows NT shell
if "%ERRORLEVEL%"=="0" goto mainEnd

:fail
rem Set variable OBP2_ONEWAY_EXIT_CONSOLE if you need the _script_ return code instead of
rem the _cmd.exe /c_ return code!
if  not "" == "%OBP2_ONEWAY_EXIT_CONSOLE%" exit 1
exit /b 1

:mainEnd
if "%OS%"=="Windows_NT" endlocal

:omega
