/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.remote;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.nio.file.Paths;
import java.util.LinkedList;
import java.util.Random;
import java.util.function.Function;
import obp2.language.remote.RemoteResource;
import obp2.language.remote.runtime.Configuration;
import obp2.language.remote.runtime.RemoteAction;
import obp2.language.remote.runtime.RemoteLanguageModule;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.ILanguagePlugin;
import obp2.runtime.core.LanguageModule;
import plug.utils.Pair;
import plug.utils.exec.ProcessRunner;

public class RemotePlugin
implements ILanguagePlugin<URI, Configuration, RemoteAction, byte[]> {
    private static final Random random = new Random();
    private static final int startPort = 3456;
    private static final LinkedList<Integer> lastSelectedPorts = new LinkedList();

    public String[] getExtensions() {
        return new String[]{".remote"};
    }

    public String getName() {
        return "Remote";
    }

    public static LanguageModule<Configuration, RemoteAction, byte[]> getLanguageModule(String host, int port) {
        return new RemoteLanguageModule(host, port);
    }

    public Function<URI, ILanguageModule<Configuration, RemoteAction, byte[]>> languageModuleFunction() {
        return description -> {
            Pair<String, Integer> endpoint = this.getEndpoint((URI)description);
            return RemotePlugin.getLanguageModule((String)endpoint.a, (Integer)endpoint.b);
        };
    }

    private Pair<String, Integer> getEndpoint(URI description) {
        RemoteResource resource = null;
        try {
            resource = (RemoteResource)new ObjectMapper().readValue(description.toURL(), RemoteResource.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int port = resource.getPort();
        if (port <= 0) {
            port = RemotePlugin.newPort();
        }
        String[] command = resource.getCommand();
        String host = resource.getHost();
        if (command != null && command.length > 0) {
            ProcessRunner runner = new ProcessRunner(new PrintWriter(System.out), new PrintWriter(System.err));
            String portString = Integer.toString(port);
            runner.setEnv(new String[]{"PLUG_PORT", portString});
            for (int i = 0; i < command.length; ++i) {
                command[i] = command[i].replaceAll("\\$PLUG_PORT", portString);
            }
            runner.setWorkingPath(Paths.get(description.getPath(), new String[0]).getParent());
            runner.startProcess(command, null);
            host = "localhost";
        }
        return new Pair((Object)host, (Object)port);
    }

    public static int newPort() {
        int port = 3456 + random.nextInt(62079);
        while (lastSelectedPorts.indexOf(port) >= 0) {
            port = 3456 + random.nextInt(62079);
        }
        if (lastSelectedPorts.size() > 10) {
            lastSelectedPorts.removeFirst();
        }
        lastSelectedPorts.addLast(port);
        return port;
    }
}

