/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.semantics.transition.utils;

import java.util.Collection;
import java.util.List;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Choreography;
import org.eclipse.bpmn2.Collaboration;
import org.eclipse.bpmn2.Participant;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.StartEvent;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.Task;
import plug.bpmn2.model.BPMNModelHandler;
import plug.bpmn2.semantics.state.BPMNRuntimeInstance;
import plug.bpmn2.semantics.state.BPMNRuntimeState;
import plug.bpmn2.semantics.state.instance.FlowElementsContainerInstance;
import plug.bpmn2.semantics.state.instance.ProcessInstance;
import plug.bpmn2.semantics.state.instance.data.ActivityState;
import plug.bpmn2.semantics.state.instance.data.Token;
import plug.bpmn2.semantics.state.instance.impl.CollaborationInstanceImpl;
import plug.bpmn2.semantics.state.instance.impl.ProcessInstanceImpl;
import plug.bpmn2.semantics.state.instance.impl.TaskInstanceImpl;

public class ElementsOpen {
    public static void addInstance(BPMNRuntimeState state, BPMNRuntimeInstance scope, BPMNRuntimeInstance instance) {
        List<BPMNRuntimeInstance> targetCollection = scope == null ? state.getRootInstanceList() : scope.getChildInstanceList();
        targetCollection.add(instance);
    }

    public static int countInstances(BPMNRuntimeState state, BPMNRuntimeInstance scope, BaseElement baseElement) {
        int result = 0;
        List<BPMNRuntimeInstance> instances = scope == null ? state.getRootInstanceList() : scope.getChildInstanceList();
        for (BPMNRuntimeInstance instance : instances) {
            if (!instance.getBaseElement().equals(baseElement)) continue;
            ++result;
        }
        return result;
    }

    public static boolean openCollaboration(BPMNModelHandler model, BPMNRuntimeState state, Collaboration collaboration, boolean execute) {
        for (BPMNRuntimeInstance rootInstance : state.getRootInstanceList()) {
            if (rootInstance.getBaseElement() != collaboration) continue;
            return false;
        }
        if (execute) {
            CollaborationInstanceImpl instance = new CollaborationInstanceImpl(null, collaboration);
            ElementsOpen.addInstance(state, null, instance);
            collaboration.getParticipants().stream().map(Participant::getProcessRef).forEach(process -> ElementsOpen.openProcess(model, state, instance, process, true));
        }
        return true;
    }

    public static void proceedStartEvent(BPMNModelHandler model, BPMNRuntimeState state, ProcessInstance processInstance, StartEvent startEvent) {
        if (startEvent.getIncoming().isEmpty() && startEvent.getIncomingConversationLinks().isEmpty()) {
            List outgoings = startEvent.getOutgoing();
            for (SequenceFlow outgoing : outgoings) {
                Token token = model.tokens.get(outgoing);
                processInstance.getTokenSet().add(token);
            }
        } else {
            if (!startEvent.getIncoming().isEmpty()) {
                throw new UnsupportedOperationException("Incoming sequence flow to a StartEvent");
            }
            throw new UnsupportedOperationException("Conversation Link to a a StartEvent");
        }
    }

    public static boolean openProcess(BPMNModelHandler model, BPMNRuntimeState state, BPMNRuntimeInstance scope, Process process, boolean execute) {
        ProcessInstanceImpl processInstance = new ProcessInstanceImpl(scope, process);
        process.getFlowElements().stream().filter(flowElement -> flowElement instanceof StartEvent).forEach(flowElement -> {
            StartEvent startEvent = (StartEvent)flowElement;
            ElementsOpen.proceedStartEvent(model, state, processInstance, startEvent);
        });
        if (processInstance.getTokenSet().isEmpty()) {
            return false;
        }
        if (execute) {
            ElementsOpen.addInstance(state, scope, processInstance);
        }
        return true;
    }

    public static boolean openTask(BPMNModelHandler model, BPMNRuntimeState state, FlowElementsContainerInstance scope, Task task, boolean execute) {
        Collection<Token> incomingTokens = model.tokens.get(task.getIncoming());
        boolean hasIncoming = false;
        for (Token token : incomingTokens) {
            if (!scope.getTokenSet().contains(token)) continue;
            if (execute) {
                scope.getTokenSet().remove(token);
            }
            hasIncoming = true;
        }
        if (!hasIncoming) {
            return false;
        }
        if (execute) {
            TaskInstanceImpl taskInstance = new TaskInstanceImpl(scope, task, ActivityState.ACTIVE);
            ElementsOpen.addInstance(state, scope, taskInstance);
        }
        return true;
    }

    public static boolean open(BPMNModelHandler model, BPMNRuntimeState state, BPMNRuntimeInstance scope, BaseElement element, boolean execute) {
        if (ElementsOpen.countInstances(state, scope, element) > 0) {
            return false;
        }
        if (element instanceof Choreography) {
            throw new UnsupportedOperationException("Open Choreography");
        }
        if (element instanceof Collaboration) {
            return ElementsOpen.openCollaboration(model, state, (Collaboration)element, execute);
        }
        if (element instanceof SubProcess) {
            throw new UnsupportedOperationException("Open SubProcess");
        }
        if (element instanceof Process) {
            return ElementsOpen.openProcess(model, state, scope, (Process)element, execute);
        }
        if (element instanceof Task) {
            FlowElementsContainerInstance parentScope = (FlowElementsContainerInstance)scope;
            return ElementsOpen.openTask(model, state, parentScope, (Task)element, execute);
        }
        throw new UnsupportedOperationException("Open " + element);
    }
}

