/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.model;

import java.net.URL;
import org.eclipse.bpmn2.Bpmn2Package;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.util.Bpmn2ResourceFactoryImpl;
import org.eclipse.bpmn2.util.Bpmn2Switch;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import plug.bpmn2.model.BPMNModelHandler;

public class BPMNLoader {
    private static boolean setupNeeded = true;
    private String modelFilePath;
    private Resource modelResource;
    private BPMNModelHandler modelHandler;

    public static void setupIfNeeded() {
        if (setupNeeded) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("bpmn", new Bpmn2ResourceFactoryImpl());
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("bpmn2", new Bpmn2ResourceFactoryImpl());
            EPackage.Registry.INSTANCE.put((Object)"http://www.omg.org/spec/BPMN/20100524/MODEL-XMI", (Object)Bpmn2Package.eINSTANCE);
            setupNeeded = false;
        }
    }

    public void loadModelFromURLString(String urlString) {
        URL modelURL = BPMNLoader.class.getClassLoader().getResource(urlString);
        this.loadModelFromURL(modelURL);
    }

    public void loadModelFromURL(URL modelURL) {
        String filePath = modelURL.toExternalForm();
        this.loadModelFromFilePath(filePath);
    }

    public void loadModelFromFilePath(String modelFilePath) {
        this.modelFilePath = modelFilePath;
        BPMNLoader.setupIfNeeded();
        ResourceSetImpl rs = new ResourceSetImpl();
        this.modelResource = rs.getResource(URI.createURI((String)this.getModelFilePath()), true);
        this.modelHandler = new BPMNModelHandler(this.getDocumentRoot());
    }

    public String getModelFilePath() {
        return this.modelFilePath;
    }

    public DocumentRoot getDocumentRoot() {
        return new DocumentRootFetcher().getRoot(this.modelResource);
    }

    public BPMNModelHandler getModelHandler() {
        return this.modelHandler;
    }

    private class DocumentRootFetcher
    extends Bpmn2Switch<DocumentRoot> {
        private DocumentRootFetcher() {
        }

        public DocumentRoot getRoot(Resource resource) {
            for (EObject object : resource.getContents()) {
                DocumentRoot documentRoot = (DocumentRoot)this.doSwitch(object);
                if (documentRoot == null) continue;
                return documentRoot;
            }
            return null;
        }

        public DocumentRoot caseDocumentRoot(DocumentRoot object) {
            return object;
        }
    }
}

