/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import javafx.util.Pair;

public class Algorithms {
    private static int[][] EMPTY_PRODUCT = new int[0][];

    private Algorithms() {
    }

    public static <T, S extends Collection<T>> List<List<T>> cartesianProduct(Collection<S> domainSet) {
        if (domainSet.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<List<Object>> result = new LinkedList<List<T>>();
        result.add(Collections.emptyList());
        for (Collection domain : domainSet) {
            LinkedList<List<T>> previousProductList = result;
            result = new LinkedList();
            for (List list : previousProductList) {
                for (Object element : domain) {
                    LinkedList product = new LinkedList(list);
                    product.add(element);
                    result.add(product);
                }
            }
        }
        return result;
    }

    public static int[][] cartesianProduct(int[][] domains) {
        if (domains.length == 0) {
            return EMPTY_PRODUCT;
        }
        int nbCombinations = 0;
        for (int[] domain : domains) {
            int domainSize = domain.length;
            if (domainSize == 0) {
                return EMPTY_PRODUCT;
            }
            nbCombinations = nbCombinations == 0 ? domainSize : nbCombinations * domainSize;
        }
        int[][] product = new int[nbCombinations][];
        int[] domain = domains[0];
        int domainSpan = nbCombinations / domain.length;
        for (int i = 0; i < nbCombinations; ++i) {
            product[i] = new int[domains.length];
            product[i][0] = domain[i / domainSpan % domain.length];
        }
        for (int domainIndex = 1; domainIndex < domains.length; ++domainIndex) {
            domain = domains[domainIndex];
            domainSpan /= domain.length;
            for (int i = 0; i < nbCombinations; ++i) {
                product[i][domainIndex] = domain[i / domainSpan % domain.length];
            }
        }
        return product;
    }

    public static void removeInsertAndTraceIndexes(int[] newIndexes, int[] newPositions, int[] oldIndexes, int[] positionsToRemove, int[] indexesToAdd) {
        int nextOld = oldIndexes.length > 0 ? oldIndexes[0] : Integer.MAX_VALUE;
        int nextRemove = positionsToRemove.length > 0 ? positionsToRemove[0] - 1 : Integer.MAX_VALUE;
        int nextAdd = indexesToAdd.length > 0 ? indexesToAdd[0] : Integer.MAX_VALUE;
        int iNew = 0;
        int iOld = 0;
        int iRemove = 0;
        int iAdd = 0;
        while (iNew < newIndexes.length) {
            if (nextRemove == iOld) {
                newPositions[iOld] = 0;
                nextOld = oldIndexes.length > ++iOld ? oldIndexes[iOld] : Integer.MAX_VALUE;
                nextRemove = ++iRemove < positionsToRemove.length ? positionsToRemove[iRemove] - 1 : Integer.MAX_VALUE;
                continue;
            }
            if (nextAdd < nextOld) {
                newIndexes[iNew] = nextAdd;
                ++iNew;
                nextAdd = ++iAdd < indexesToAdd.length ? indexesToAdd[iAdd] : Integer.MAX_VALUE;
                continue;
            }
            newIndexes[iNew] = nextOld;
            newPositions[iOld] = ++iNew;
            nextOld = oldIndexes.length > ++iOld ? oldIndexes[iOld] : Integer.MAX_VALUE;
        }
    }

    public static <T> int[] getSortedIndexArray(Function<T, Integer> indexFunction, Collection<T> collection) {
        int[] result = new int[collection.size()];
        int i = 0;
        for (T object : collection) {
            result[i++] = indexFunction.apply(object);
        }
        Arrays.sort(result);
        return result;
    }

    public static <T> void biSort(int[] toSortArray, T[] toMirrorArray) {
        if (toSortArray.length != toMirrorArray.length) {
            throw new IllegalArgumentException("toSortArray.length != toMirrorArray.length");
        }
        LinkedList<Pair> pairList = new LinkedList<Pair>();
        for (int i = 0; i < toSortArray.length; ++i) {
            pairList.add(new Pair((Object)toSortArray[i], toMirrorArray[i]));
        }
        pairList.sort(Comparator.comparingInt(Pair::getKey));
        int index = 0;
        for (Pair pair : pairList) {
            toSortArray[index] = (Integer)pair.getKey();
            toMirrorArray[index] = pair.getValue();
            ++index;
        }
    }
}

