/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.semantics;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import obp2.bpmn2.model.BPMN2ProcessedModel;
import obp2.bpmn2.model.action.BPMN2FlowAction;
import obp2.bpmn2.semantics.BPMN2ExecutionState;
import obp2.bpmn2.semantics.BPMN2Semantics;

public class BPMN2SemanticsFlowCompletion
implements BPMN2Semantics {
    private final BPMN2ProcessedModel model;
    private final BPMN2Semantics semantics;

    public BPMN2SemanticsFlowCompletion(BPMN2ProcessedModel model, BPMN2Semantics semantics) {
        this.model = model;
        this.semantics = semantics;
    }

    public static boolean isFlowAction(BPMN2FlowAction flowAction) {
        switch (flowAction.getType()) {
            case END_TASK: 
            case THROW_SIGNAL: {
                return false;
            }
        }
        return true;
    }

    @Override
    public Set<BPMN2ExecutionState> execute(BPMN2ExecutionState source, BPMN2FlowAction flowAction) {
        Set<BPMN2ExecutionState> naiveTargets = this.semantics.execute(source, flowAction);
        HashSet<BPMN2ExecutionState> completedTargets = new HashSet<BPMN2ExecutionState>();
        Iterator<BPMN2ExecutionState> iterator = naiveTargets.iterator();
        while (iterator.hasNext()) {
            BPMN2ExecutionState naiveTarget;
            BPMN2ExecutionState completedTarget = naiveTarget = iterator.next();
            boolean hasFlowAction = true;
            block1: while (hasFlowAction) {
                hasFlowAction = false;
                for (BPMN2FlowAction interAction : this.model.getFlowActionPool().getFlowActionArray()) {
                    Set<BPMN2ExecutionState> newTargets;
                    if (completedTarget.tokens.length <= 0 || !BPMN2SemanticsFlowCompletion.isFlowAction(interAction) || !this.semantics.canFire(completedTarget, interAction) || (newTargets = this.semantics.execute(completedTarget, interAction)).size() == 0) continue;
                    hasFlowAction = true;
                    completedTarget = (BPMN2ExecutionState)((Object)newTargets.stream().findAny().get());
                    continue block1;
                }
            }
            completedTargets.add(completedTarget);
        }
        return completedTargets;
    }

    @Override
    public boolean canFire(BPMN2ExecutionState source, BPMN2FlowAction action) {
        return this.semantics.canFire(source, action);
    }
}

