/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.model.signal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import obp2.bpmn2.model.signal.SignalData;
import obp2.bpmn2.model.signal.SignalIdStrategy;
import obp2.bpmn2.model.signal.SignalReferences;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CatchEvent;
import org.eclipse.bpmn2.Event;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.IntermediateCatchEvent;
import org.eclipse.bpmn2.IntermediateThrowEvent;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.ThrowEvent;

public class SignalDataUtils {
    public static SignalData compute(Set<Process> rootProcesses, SignalIdStrategy signalIdStrategy) {
        HashMap<Object, List<ThrowEvent>> throwMap = new HashMap<Object, List<ThrowEvent>>();
        HashMap<Object, List<CatchEvent>> catchMap = new HashMap<Object, List<CatchEvent>>();
        LinkedList<Process> toSeeProcesses = new LinkedList<Process>(rootProcesses);
        HashSet<Process> visitedProcesses = new HashSet<Process>(toSeeProcesses);
        while (!toSeeProcesses.isEmpty()) {
            Process process = toSeeProcesses.removeFirst();
            for (FlowElement flowElement : process.getFlowElements()) {
                Process calledProcess;
                CallActivity callActivity;
                Object signal;
                ThrowEvent event;
                if (flowElement instanceof IntermediateThrowEvent) {
                    event = (ThrowEvent)flowElement;
                    signal = signalIdStrategy.getSignalId((Event)event);
                    throwMap.computeIfAbsent(signal, s -> new ArrayList()).add(event);
                    continue;
                }
                if (flowElement instanceof IntermediateCatchEvent) {
                    event = (CatchEvent)flowElement;
                    signal = signalIdStrategy.getSignalId((Event)event);
                    catchMap.computeIfAbsent(signal, s -> new ArrayList()).add(event);
                    continue;
                }
                if (!(flowElement instanceof CallActivity) || !((callActivity = (CallActivity)flowElement).getCalledElementRef() instanceof Process) || !visitedProcesses.add(calledProcess = (Process)callActivity.getCalledElementRef())) continue;
                toSeeProcesses.addLast(calledProcess);
            }
        }
        return SignalDataUtils.buildSignalData(signalIdStrategy, throwMap, catchMap);
    }

    private static SignalData buildSignalData(SignalIdStrategy signalIdStrategy, Map<Object, List<ThrowEvent>> throwMap, Map<Object, List<CatchEvent>> catchMap) {
        HashSet<Object> signalSet = new HashSet<Object>();
        signalSet.addAll(throwMap.keySet());
        signalSet.addAll(catchMap.keySet());
        SignalData signalData = new SignalData(signalIdStrategy);
        for (Object e : signalSet) {
            if (e == null) continue;
            List throwEventList = throwMap.computeIfAbsent(e, s -> new ArrayList());
            ThrowEvent[] throwEventArray = new ThrowEvent[throwEventList.size()];
            for (int i = 0; i < throwEventArray.length; ++i) {
                throwEventArray[i] = (ThrowEvent)throwEventList.get(i);
            }
            List catchEventList = catchMap.computeIfAbsent(e, s -> new ArrayList());
            CatchEvent[] catchEventArray = new CatchEvent[catchEventList.size()];
            for (int i = 0; i < catchEventArray.length; ++i) {
                catchEventArray[i] = (CatchEvent)catchEventList.get(i);
            }
            SignalReferences signalReferences = new SignalReferences(e, throwEventArray, catchEventArray);
            signalData.getSignalReferencesMap().put(e, signalReferences);
        }
        return signalData;
    }

    public static String getReportString(SignalData signalData) {
        StringBuilder report = new StringBuilder();
        report.append("Model has ").append(signalData.getSignalReferencesMap().keySet().size()).append(" different signals");
        int maxThrow = 0;
        int maxCatch = 0;
        int noThrow = 0;
        int noCatch = 0;
        for (SignalReferences signalReferences : signalData.getSignalReferencesMap().values()) {
            int nbThrow = signalReferences.getThrowEvents().length;
            int nbCatch = signalReferences.getCatchEvents().length;
            if (nbThrow > maxThrow) {
                maxThrow = nbThrow;
            }
            if (nbCatch > maxCatch) {
                maxCatch = nbCatch;
            }
            if (nbThrow == 0) {
                ++noThrow;
            }
            if (nbCatch != 0) continue;
            ++noCatch;
        }
        report.append("\n").append("Max number of throws: ").append(maxThrow).append("\n").append("Max number of catchs: ").append(maxCatch).append("\n").append("Signals with no throw: ").append(noThrow).append("\n").append("Signals with no catch: ").append(noCatch);
        return report.toString();
    }
}

