/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.extended.marshalling;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import obp2.bpmn2.model.BPMN2ProcessedModel;
import obp2.bpmn2.model.action.BPMN2FlowAction;
import obp2.bpmn2.plugin.BPMN2Module;
import obp2.bpmn2.semantics.BPMN2ExecutionState;
import obp2.runtime.core.ILanguageModule;
import obp2.runtime.core.IMarshaller;
import plug.utils.marshaling.Marshaller;
import plug.utils.marshaling.Unmarshaller;

public class BPMN2Marshaller
implements IMarshaller<BPMN2ExecutionState, BPMN2FlowAction, Void> {
    private BPMN2Module module;

    public ILanguageModule<BPMN2ExecutionState, BPMN2FlowAction, Void> getModule() {
        return this.module;
    }

    public void setModule(ILanguageModule<BPMN2ExecutionState, BPMN2FlowAction, Void> module) {
        if (!(module instanceof BPMN2Module)) {
            throw new RuntimeException("BPMN2Module expected");
        }
        this.module = (BPMN2Module)module;
    }

    public byte[] serializeConfiguration(BPMN2ExecutionState configuration) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            BPMN2Marshaller.writeState(configuration, os);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception while writing a state", e);
        }
        return os.toByteArray();
    }

    public byte[] serializeFireable(BPMN2FlowAction fireable) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            BPMN2Marshaller.writeAction(fireable, os);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception while writing an action", e);
        }
        return os.toByteArray();
    }

    public byte[] serializeOutput(Void output) {
        return new byte[0];
    }

    public BPMN2ExecutionState deserializeConfiguration(byte[] buffer) {
        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
        try {
            return BPMN2Marshaller.readState(is);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception while reading a state", e);
        }
    }

    public BPMN2FlowAction deserializeFireable(byte[] buffer) {
        ByteArrayInputStream is = new ByteArrayInputStream(buffer);
        try {
            return BPMN2Marshaller.readAction(this.module.getModel(), is);
        }
        catch (IOException e) {
            throw new RuntimeException("IO Exception while reading an action", e);
        }
    }

    public Void deserializeOutput(byte[] buffer) {
        return null;
    }

    private static void writeState(BPMN2ExecutionState state, OutputStream os) throws IOException {
        Marshaller.writeIntArray((int[])state.tokens, (OutputStream)os);
    }

    private static BPMN2ExecutionState readState(InputStream is) throws IOException {
        int[] tokens = new int[Unmarshaller.readInt((InputStream)is)];
        for (int index = 0; index < tokens.length; ++index) {
            tokens[index] = Unmarshaller.readInt((InputStream)is);
        }
        return new BPMN2ExecutionState(tokens);
    }

    private static void writeAction(BPMN2FlowAction action, OutputStream os) throws IOException {
        Marshaller.writeInt((int)action.getId(), (OutputStream)os);
    }

    private static BPMN2FlowAction readAction(BPMN2ProcessedModel model, InputStream is) throws IOException {
        int actionId = Unmarshaller.readInt((InputStream)is);
        return model.getFlowActionPool().getFlowAction(actionId);
    }
}

