/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.semantics.transition.utils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.InteractionNode;
import org.eclipse.bpmn2.MessageFlow;
import org.eclipse.emf.ecore.EObject;
import plug.bpmn2.model.BPMNModelHandler;
import plug.bpmn2.semantics.state.BPMNRuntimeInstance;
import plug.bpmn2.semantics.state.BPMNRuntimeState;
import plug.bpmn2.semantics.state.instance.data.MessageFlowData;

public class ElementsMessageFlow {
    public static Collection<MessageFlow> getMessageFlows(BPMNModelHandler model) {
        return model.containment.getNodeSet().stream().filter(object -> object instanceof MessageFlow).map(object -> (MessageFlow)object).collect(Collectors.toList());
    }

    private static BPMNRuntimeInstance getOwner(List<BPMNRuntimeInstance> instanceList, EObject container) {
        for (BPMNRuntimeInstance instance : instanceList) {
            if (instance.getBaseElement() == container) {
                return instance;
            }
            BPMNRuntimeInstance childOwner = ElementsMessageFlow.getOwner(instance.getChildInstanceList(), container);
            if (childOwner == null) continue;
            return childOwner;
        }
        return null;
    }

    public static BPMNRuntimeInstance getOwner(BPMNRuntimeState state, InteractionNode interactionNode) {
        EObject container = interactionNode.eContainer();
        return ElementsMessageFlow.getOwner(state.getRootInstanceList(), container);
    }

    public static BaseElement getBaseElement(InteractionNode interactionNode) {
        return (BaseElement)interactionNode;
    }

    public static MessageFlowData createMessageFlowData(BPMNRuntimeState state, MessageFlow messageFlow, boolean isPresent) {
        BPMNRuntimeInstance sourceOwner = ElementsMessageFlow.getOwner(state, messageFlow.getSourceRef());
        if (sourceOwner == null) {
            return null;
        }
        BPMNRuntimeInstance targetOwner = ElementsMessageFlow.getOwner(state, messageFlow.getTargetRef());
        if (targetOwner == null) {
            return null;
        }
        return new MessageFlowData(messageFlow, sourceOwner, targetOwner, isPresent);
    }

    public static int getMessageFlowIndex(BPMNRuntimeState state, BaseElement baseElement, boolean source) {
        for (int i = 0; i < state.getMessageFlowDataList().size(); ++i) {
            MessageFlowData currentMessageFlowData = state.getMessageFlowDataList().get(i);
            InteractionNode currentInteractionNode = source ? currentMessageFlowData.getBaseElement().getSourceRef() : currentMessageFlowData.getBaseElement().getTargetRef();
            BaseElement currentBaseElement = ElementsMessageFlow.getBaseElement(currentInteractionNode);
            if (baseElement != currentBaseElement) continue;
            return i;
        }
        return -1;
    }

    private static boolean isPresent(BPMNRuntimeState state, int messageFlowIndex) {
        return state.getMessageFlowDataList().get(messageFlowIndex).getData();
    }

    public static boolean attemptToReceive(BPMNRuntimeState source, BPMNRuntimeState target, InteractionNode interactionNode) {
        if (!(interactionNode instanceof BaseElement)) {
            throw new IllegalArgumentException("interactionNode is not a BaseElement");
        }
        BaseElement baseElement = (BaseElement)interactionNode;
        int messageFlowIndex = ElementsMessageFlow.getMessageFlowIndex(source, baseElement, false);
        if (messageFlowIndex == -1) {
            throw new IllegalArgumentException("could not find a matching MessageFlow");
        }
        MessageFlowData messageFlowData = source.getMessageFlowDataList().get(messageFlowIndex);
        if (!messageFlowData.getData().booleanValue()) {
            return false;
        }
        if (target != null) {
            MessageFlowData targetMessageFlowData = target.getMessageFlowDataList().get(messageFlowIndex);
            MessageFlowData nextMessageFlowData = new MessageFlowData(targetMessageFlowData.getBaseElement(), targetMessageFlowData.getSourceParent(), targetMessageFlowData.getTargetParent(), false);
            target.getMessageFlowDataList().set(messageFlowIndex, nextMessageFlowData);
        }
        return true;
    }
}

