/*
 * Decompiled with CFR 0.152.
 */
package plug.bpmn2.semantics.state.instance.data;

public enum ActivityState {
    INACTIVE,
    READY,
    ACTIVE,
    COMPLETING,
    COMPLETED,
    WITHDRAWN,
    FAILING,
    FAILED,
    TERMINATING,
    TERMINATED,
    COMPENSATING,
    COMPENSATED,
    CLOSED;

    private static final boolean[][] TRANSITION_MATRIX;

    private static void markTransition(ActivityState source, ActivityState target) {
        ActivityState.TRANSITION_MATRIX[source.ordinal()][target.ordinal()] = true;
    }

    private static void markTransitions(ActivityState source, ActivityState ... targets) {
        for (ActivityState target : targets) {
            ActivityState.markTransition(source, target);
        }
    }

    public boolean hasTransitionTo(ActivityState other) {
        return TRANSITION_MATRIX[this.ordinal()][other.ordinal()];
    }

    static {
        ActivityState[] states = ActivityState.values();
        int size = states.length;
        TRANSITION_MATRIX = new boolean[size][];
        for (int i = 0; i < size; ++i) {
            ActivityState.TRANSITION_MATRIX[i] = new boolean[size];
        }
        block16: for (ActivityState source : states) {
            switch (source) {
                case INACTIVE: {
                    ActivityState.markTransitions(source, READY);
                    continue block16;
                }
                case READY: {
                    ActivityState.markTransitions(source, ACTIVE, FAILING, TERMINATING, WITHDRAWN);
                    continue block16;
                }
                case ACTIVE: {
                    ActivityState.markTransitions(source, COMPLETING, FAILING, TERMINATING, WITHDRAWN);
                    continue block16;
                }
                case COMPLETING: {
                    ActivityState.markTransitions(source, COMPLETED, FAILING, TERMINATING);
                    continue block16;
                }
                case COMPLETED: {
                    ActivityState.markTransitions(source, CLOSED, COMPENSATING);
                    continue block16;
                }
                case WITHDRAWN: {
                    ActivityState.markTransitions(source, CLOSED);
                    continue block16;
                }
                case FAILING: {
                    ActivityState.markTransitions(source, FAILED);
                    continue block16;
                }
                case FAILED: {
                    ActivityState.markTransitions(source, CLOSED);
                    continue block16;
                }
                case TERMINATING: {
                    ActivityState.markTransitions(source, FAILED, TERMINATED);
                    continue block16;
                }
                case TERMINATED: {
                    ActivityState.markTransitions(source, CLOSED);
                    continue block16;
                }
                case COMPENSATING: {
                    ActivityState.markTransitions(source, COMPENSATED, FAILED, TERMINATED);
                    continue block16;
                }
                case COMPENSATED: {
                    ActivityState.markTransitions(source, CLOSED);
                    continue block16;
                }
                case CLOSED: {
                    ActivityState.markTransitions(source, new ActivityState[0]);
                }
            }
        }
    }
}

