/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SequenceFlow;

public class BPMN2ModelValidation {
    public static boolean nodesAreMissingFlows(Set<Process> rootProcesses) {
        for (Process rootProcess : rootProcesses) {
            for (FlowElement flowElement : rootProcess.getFlowElements()) {
                if (!(flowElement instanceof FlowNode)) continue;
                FlowNode flowNode = (FlowNode)flowElement;
                if (!flowNode.getIncoming().isEmpty()) {
                    return false;
                }
                if (flowNode.getOutgoing().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public static void addMissingFlows(Set<Process> rootProcesses) {
        System.err.println("Model is missing flow nodes' explicit flow data");
        HashSet<Process> knownProcesses = new HashSet<Process>(rootProcesses);
        ArrayList<Process> toSeeProcesses = new ArrayList<Process>(rootProcesses);
        while (!toSeeProcesses.isEmpty()) {
            Process currentProcess = (Process)toSeeProcesses.remove(toSeeProcesses.size() - 1);
            for (FlowElement flowElement : currentProcess.getFlowElements()) {
                FlowNode target;
                if (flowElement instanceof CallActivity) {
                    Process discoveredProcess;
                    CallActivity callActivity = (CallActivity)flowElement;
                    CallableElement callableElement = callActivity.getCalledElementRef();
                    if (!(callableElement instanceof Process) || !knownProcesses.add(discoveredProcess = (Process)callableElement)) continue;
                    toSeeProcesses.add(discoveredProcess);
                    continue;
                }
                if (!(flowElement instanceof SequenceFlow)) continue;
                SequenceFlow sequenceFlow = (SequenceFlow)flowElement;
                FlowNode source = sequenceFlow.getSourceRef();
                if (source != null) {
                    source.getOutgoing().add(sequenceFlow);
                }
                if ((target = sequenceFlow.getTargetRef()) == null) continue;
                target.getIncoming().add(sequenceFlow);
            }
        }
        System.err.println("Added incoming and outgoing data to flow nodes");
    }
}

