/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.pocs;

import obp2.bpmn2.model.BPMN2ProcessedModel;
import obp2.bpmn2.model.RootProcesses;
import obp2.bpmn2.pocs.DANaiveExploration;
import obp2.bpmn2.utils.BPMN2EmfUtils;
import org.eclipse.bpmn2.DocumentRoot;
import org.eclipse.bpmn2.Process;

public class DCNaiveExplorationPerProcess {
    public static void exploreOneProcessAsRootProcess(DocumentRoot documentRoot, Process process, int cap) {
        System.out.println("Exploring with \"" + process.getName() + "\" as the root process ...");
        BPMN2ProcessedModel processedModel = new BPMN2ProcessedModel(documentRoot, process);
        DANaiveExploration.pocNaiveExploration(processedModel, true, cap);
        DANaiveExploration.pocNaiveExploration(processedModel, false, cap);
    }

    public static void exploreAllProcessesAsRootProcess(DocumentRoot documentRoot, int cap) {
        for (Process process : RootProcesses.computeAllProcesses(documentRoot)) {
            DCNaiveExplorationPerProcess.exploreOneProcessAsRootProcess(documentRoot, process, cap);
        }
    }

    public static void main(String[] args) {
        System.out.println("Loading ...");
        DocumentRoot documentRoot = BPMN2EmfUtils.getDocumentRoot("resources/tests/oneWay_reloaded.bpmn");
        DCNaiveExplorationPerProcess.exploreAllProcessesAsRootProcess(documentRoot, 10000);
    }
}

