/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.model.token;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import obp2.bpmn2.model.token.Token;
import obp2.bpmn2.model.token.TokenPool;
import org.eclipse.bpmn2.Activity;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.CallableElement;
import org.eclipse.bpmn2.FlowElement;
import org.eclipse.bpmn2.FlowNode;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.SequenceFlow;
import org.eclipse.bpmn2.Task;

public class TokenPoolUtils {
    public static TokenPool compute(Set<Process> rootProcesses, boolean includeCalledProcesses) {
        LinkedList<Token> tokenList = new LinkedList<Token>();
        for (Process process : rootProcesses) {
            List<CallActivity> callStack = Collections.emptyList();
            TokenPoolUtils.addTokens(tokenList, callStack, process, includeCalledProcesses);
        }
        TokenPool result = new TokenPool(tokenList);
        return result;
    }

    public static TokenPool compute(Set<Process> rootProcesses) {
        return TokenPoolUtils.compute(rootProcesses, true);
    }

    public static FlowNode getActionFlowNodeFrom(BaseElement placeBaseElement) {
        if (placeBaseElement instanceof Activity) {
            return (FlowNode)placeBaseElement;
        }
        if (placeBaseElement instanceof SequenceFlow) {
            return ((SequenceFlow)placeBaseElement).getTargetRef();
        }
        throw new IllegalStateException("Unsupported base element as place for tokens");
    }

    private static void addTokens(List<Token> tokenList, List<CallActivity> callStack, Process process, boolean includeCalledProcesses) {
        for (FlowElement flowElement : process.getFlowElements()) {
            if (flowElement instanceof SequenceFlow) {
                tokenList.add(new Token(callStack, (BaseElement)flowElement));
                continue;
            }
            if (flowElement instanceof CallActivity) {
                tokenList.add(new Token(callStack, (BaseElement)flowElement));
                CallActivity callActivity = (CallActivity)flowElement;
                CallableElement calledElement = callActivity.getCalledElementRef();
                if (!includeCalledProcesses || !(calledElement instanceof Process)) continue;
                Process calledProcess = (Process)calledElement;
                TokenPoolUtils.checkCallCycle(callStack, calledProcess);
                LinkedList<CallActivity> newCallStack = new LinkedList<CallActivity>(callStack);
                newCallStack.add(callActivity);
                TokenPoolUtils.addTokens(tokenList, newCallStack, calledProcess, true);
                continue;
            }
            if (!(flowElement instanceof Task)) continue;
            tokenList.add(new Token(callStack, (BaseElement)flowElement));
        }
    }

    private static void checkCallCycle(List<CallActivity> callStack, Process calledProcess) {
        for (CallActivity callActivity : callStack) {
            Process owner = (Process)callActivity.eContainer();
            if (owner != calledProcess) continue;
            throw new IllegalStateException("Call cycle detected and unsupported");
        }
    }

    public static String getReportString(TokenPool tokenPool) {
        StringBuilder report = new StringBuilder();
        report.append("TokenPool has ").append(tokenPool.getTokenArray().length).append(" tokens.");
        int maxCallDepth = 0;
        int nbSequenceFlow = 0;
        int nbTask = 0;
        int nbCallActivity = 0;
        for (Token token : tokenPool.getTokenArray()) {
            if (token.getCallStack().size() > maxCallDepth) {
                maxCallDepth = token.getCallStack().size();
            }
            if (token.getPlaceBaseElement() instanceof SequenceFlow) {
                ++nbSequenceFlow;
                continue;
            }
            if (token.getPlaceBaseElement() instanceof Task) {
                ++nbTask;
                continue;
            }
            if (!(token.getPlaceBaseElement() instanceof CallActivity)) continue;
            ++nbCallActivity;
        }
        report.append("\n").append("Places: ").append(nbSequenceFlow).append(" sequence flows, ").append(nbTask).append(" tasks, ").append(nbCallActivity).append(" call activities.");
        report.append("\n").append("Maximum call stack size: ").append(maxCallDepth).append(".");
        return report.toString();
    }
}

