/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.model.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.bpmn2.FlowNode;

public class BPMN2FlowAction {
    private int id = -1;
    private FlowNode flowNode = null;
    private final Type type;
    private int[] mandatoryTokens;
    private int[] producedTokens;
    private int[] excludedTokens;
    private int[] optionalTokens;
    private Map<Integer, int[]> optionalProducedTokenMap;

    public BPMN2FlowAction(Type type) {
        this.type = type;
        this.mandatoryTokens = new int[0];
        this.producedTokens = new int[0];
        this.excludedTokens = new int[0];
        this.optionalTokens = new int[0];
        this.optionalProducedTokenMap = new HashMap<Integer, int[]>();
    }

    public FlowNode getFlowNode() {
        return this.flowNode;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setFlowNode(FlowNode flowNode) {
        this.flowNode = flowNode;
    }

    public Type getType() {
        return this.type;
    }

    public int[] getMandatoryTokens() {
        return this.mandatoryTokens;
    }

    public void setMandatoryTokens(int[] mandatoryTokens) {
        this.mandatoryTokens = mandatoryTokens;
    }

    public void setMandatoryTokens(int singleToken) {
        this.mandatoryTokens = new int[]{singleToken};
    }

    public int[] getExcludedTokens() {
        return this.excludedTokens;
    }

    public void setExcludedTokens(int[] excludedTokens) {
        this.excludedTokens = excludedTokens;
    }

    public int[] getOptionalTokens() {
        return this.optionalTokens;
    }

    public void setOptionalTokens(int[] optionalTokens) {
        this.optionalTokens = optionalTokens;
    }

    public int[] getProducedTokens() {
        return this.producedTokens;
    }

    public void setProducedTokens(int[] producedTokens) {
        this.producedTokens = producedTokens;
    }

    public void setProducedTokens(int singleToken) {
        this.producedTokens = new int[]{singleToken};
    }

    public void setProducedTokens(List<Integer> tokensAsList) {
        this.producedTokens = new int[tokensAsList.size()];
        for (int i = 0; i < this.producedTokens.length; ++i) {
            this.producedTokens[i] = tokensAsList.get(i);
        }
    }

    public int[] getProducedTokens(int optionalToken) {
        return this.optionalProducedTokenMap.get(optionalToken);
    }

    public void setOptionalProducedTokenMap(Map<Integer, int[]> optionalProducedTokenMap) {
        this.optionalProducedTokenMap = optionalProducedTokenMap;
    }

    public static enum Type {
        INITIALISATION,
        START_TASK,
        END_TASK,
        OPEN_PROCESS,
        CLOSE_PROCESS,
        TRAVERSE_PAR_GATEWAY,
        TRAVERSE_EXC_GATEWAY,
        TRAVERSE_THROW_LESS_CATCH,
        THROW_SIGNAL,
        END_EVENT;

    }
}

