/*
 * Decompiled with CFR 0.152.
 */
package obp2.bpmn2.extended.timed.interval;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Objects;
import obp2.bpmn2.extended.timed.interval.Intervals;

public class Interval {
    public static final int NEG_INFINITY = Integer.MIN_VALUE;
    public static final int POS_INFINITY = Integer.MAX_VALUE;
    private final int minValue;
    private final boolean minIncluded;
    private final int maxValue;
    private final boolean maxIncluded;

    public Interval(int minValue, boolean minIncluded, int maxValue, boolean maxIncluded) {
        if (minValue == Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Intervals can't have positive infinity minimum");
        }
        if (maxValue == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("Intervals can't have negative infinity maximum");
        }
        if (maxValue == Integer.MAX_VALUE && maxIncluded || minValue == Integer.MIN_VALUE && minIncluded) {
            throw new IllegalArgumentException("Intervals can't include infinity");
        }
        this.minValue = minValue;
        this.minIncluded = minIncluded;
        this.maxValue = maxValue;
        this.maxIncluded = maxIncluded;
    }

    public Interval(Interval other) {
        this(other.getMinValue(), other.isMinIncluded(), other.getMaxValue(), other.isMaxIncluded());
    }

    @JsonCreator
    public Interval(String jsonString) {
        this(Intervals.parseInterval(jsonString));
    }

    public int getMinValue() {
        return this.minValue;
    }

    public boolean isMinIncluded() {
        return this.minIncluded;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public boolean isMaxIncluded() {
        return this.maxIncluded;
    }

    public boolean isMinInfinity() {
        return this.minValue == Integer.MIN_VALUE;
    }

    public boolean isMaxInfinity() {
        return this.maxValue == Integer.MAX_VALUE;
    }

    public boolean isEmpty() {
        if (!(this.maxValue != this.minValue || this.minIncluded && this.maxIncluded)) {
            return true;
        }
        return this.minValue > this.maxValue;
    }

    public boolean includes(int value) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.minIncluded && this.minValue == value) {
            return true;
        }
        if (this.maxIncluded && this.maxValue == value) {
            return true;
        }
        return value > this.minValue && value < this.maxValue;
    }

    public boolean includes(Interval other) {
        if (other.isEmpty()) {
            return true;
        }
        if (this.isEmpty()) {
            return false;
        }
        if (other.getMinValue() < this.getMinValue()) {
            return false;
        }
        if (other.getMaxValue() > this.getMaxValue()) {
            return false;
        }
        if (other.isMinIncluded() && !this.includes(other.getMinValue())) {
            return false;
        }
        return !other.isMaxIncluded() || this.includes(other.getMaxValue());
    }

    public Interval inter(Interval other) {
        if (this.includes(other)) {
            return this;
        }
        if (other.includes(this)) {
            return other;
        }
        if (this.getMaxValue() == other.getMinValue()) {
            if (!this.isMaxIncluded() || !other.isMinIncluded()) {
                return Intervals.EMPTY;
            }
            return Intervals.exact(this.getMaxValue());
        }
        if (this.getMinValue() == other.getMaxValue()) {
            if (!this.isMinIncluded() || !other.isMaxIncluded()) {
                return Intervals.EMPTY;
            }
            return Intervals.exact(this.getMinValue());
        }
        if (this.getMaxValue() < other.getMinValue()) {
            return Intervals.EMPTY;
        }
        if (this.getMinValue() > other.getMaxValue()) {
            return Intervals.EMPTY;
        }
        Interval minHolder = this.includes(other.getMinValue()) ? other : this;
        Interval maxHolder = this == minHolder ? other : this;
        return new Interval(minHolder.getMinValue(), minHolder.isMinIncluded(), maxHolder.getMaxValue(), maxHolder.isMaxIncluded());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval that = (Interval)o;
        return this.minValue == that.minValue && this.minIncluded == that.minIncluded && this.maxValue == that.maxValue && this.maxIncluded == that.maxIncluded;
    }

    public int hashCode() {
        return Objects.hash(this.minValue, this.minIncluded, this.maxValue, this.maxIncluded);
    }

    public String toString() {
        return Intervals.toString(this);
    }

    @JsonValue
    protected String toJsonString() {
        return Intervals.toString(this);
    }
}

