/*
 * Decompiled with CFR 0.152.
 */
package obp.ui.explorer;

import obp.dot.Graph;
import obp.dot.util.DotUtil;
import obp.explorer.ConfsFileHandler;
import obp.explorer.runtime.evaluator.Tester;
import obp.ui.dot.diagram.GraphDiagram;
import obp.ui.explorer.ConfsFileHandlerController;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.Validator;
import org.xid.basics.notification.Notification;
import org.xid.basics.notification.NotificationListener;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.ui.action.Action;
import org.xid.basics.ui.diagram.Diagram;
import org.xid.basics.ui.dialog.FieldShellToolkit;
import org.xid.basics.ui.field.CompositeField;
import org.xid.basics.ui.field.DiagramField;
import org.xid.basics.ui.field.Field;
import org.xid.basics.ui.field.TextField;

public class ShowGraphAction
extends Action.Stub {
    private final ConfsFileHandlerController parent;
    private TextField predicateField;
    private DiagramField<Graph> graphField;
    private FieldShellToolkit toolkit;
    private String predicateErrorMessage;
    private boolean loading = false;
    private boolean nodeDescription;
    private Graph initialGraph;
    private Graph initialGraphNodeDescription;

    public ShowGraphAction(ConfsFileHandlerController parent) {
        super("Graph");
        this.parent = parent;
    }

    public int getVisibility() {
        ConfsFileHandler subject = (ConfsFileHandler)this.parent.getSubject();
        if (subject == null) {
            return 2;
        }
        if (subject.getConfiguration(500) != null) {
            return 2;
        }
        return this.loading ? 4 : 1;
    }

    public int run(ActionMonitor monitor) {
        final ConfsFileHandler confs = (ConfsFileHandler)this.parent.getSubject();
        if (confs == null) {
            return 3;
        }
        this.nodeDescription = false;
        this.loading = true;
        Thread loader = new Thread(new Runnable(){

            @Override
            public void run() {
                confs.readAll();
                if (confs.getConfigurationCount() > 500) {
                    return;
                }
                ShowGraphAction.this.initialGraph = ShowGraphAction.this.computeGraph(null, false);
                ShowGraphAction.this.initialGraphNodeDescription = ShowGraphAction.this.computeGraph(null, true);
                ShowGraphAction.this.loading = false;
                ShowGraphAction.this.openGraphDialog();
            }
        });
        loader.start();
        return 1;
    }

    private Graph computeGraph(Tester tester, boolean nodeDescription) {
        String dot = ((ConfsFileHandler)this.parent.getSubject()).toDot(tester, nodeDescription);
        try {
            return DotUtil.layoutDot(dot);
        }
        catch (Exception e) {
            return null;
        }
    }

    private Tester createTester() {
        this.predicateErrorMessage = null;
        ConfsFileHandler confs = (ConfsFileHandler)this.parent.getSubject();
        if (confs == null) {
            this.predicateErrorMessage = "No configuration to filter.";
            return null;
        }
        String predicateString = this.predicateField.getValue();
        if (predicateString == null) {
            this.predicateErrorMessage = "No predicate to search for.";
            return null;
        }
        try {
            return confs.createTester(predicateString);
        }
        catch (NullPointerException e) {
            this.predicateErrorMessage = "Invalid predicate";
            return null;
        }
        catch (Exception e) {
            this.predicateErrorMessage = e.getMessage();
            return null;
        }
    }

    private void updateGraph() {
        Tester tester = this.createTester();
        if (tester != null) {
            this.graphField.setValue((Object)this.computeGraph(tester, this.nodeDescription));
        } else {
            this.graphField.setValue((Object)(this.nodeDescription ? this.initialGraphNodeDescription : this.initialGraph));
        }
    }

    private void openGraphDialog() {
        this.predicateField = new TextField(null, 4);
        this.predicateField.setValidator((Validator)new Validator<String>(){

            public boolean isValid(String value) {
                if (value == null) {
                    return true;
                }
                return ShowGraphAction.this.createTester() != null;
            }

            public Diagnostic getDiagnostic() {
                return new Diagnostic.Stub(2, ShowGraphAction.this.predicateErrorMessage);
            }
        });
        this.predicateField.addAction((Action)new Action.Stub(282){

            public boolean getState() {
                return ShowGraphAction.this.nodeDescription;
            }

            public int run(ActionMonitor monitor) {
                ShowGraphAction.this.nodeDescription = !ShowGraphAction.this.nodeDescription;
                ShowGraphAction.this.updateGraph();
                return 1;
            }
        });
        this.graphField = new DiagramField((Diagram)new GraphDiagram());
        this.graphField.addAction(this.graphField.getController().createIncreaseZoomAction());
        this.graphField.addAction(this.graphField.getController().createDecreaseZoomAction());
        this.graphField.addAction(this.graphField.getController().createSaveImageAction());
        this.graphField.setValue((Object)this.initialGraph);
        this.predicateField.addListener(new NotificationListener(){

            public void notified(Notification notification) {
                ShowGraphAction.this.updateGraph();
            }
        });
        final Display display = Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = FieldShellToolkit.createShell((Display)display, (String)"OBP: Graph");
                ShowGraphAction.this.toolkit = new FieldShellToolkit(shell, "Graph", 0, (Field)new CompositeField(new Field[]{ShowGraphAction.this.predicateField, ShowGraphAction.this.graphField}));
                ShowGraphAction.this.toolkit.init();
                shell.setSize(640, 480);
                shell.open();
            }
        });
    }
}

