/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import obp.cc.ConcreteContext;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.DBM;
import obp.explorer.runtime.core.Channel;
import obp.explorer.runtime.obs.ObsConfiguration;
import obp.explorer.runtime.simulation.InteractiveSimulator;
import obp.obs.Observer;
import obp.simulation.component.ConfigurationViewer;
import obp.simulation.component.ObserverDialog;
import obp.simulation.model.ConfigurationTreeRenderer;
import obp.simulation.model.NodeWithIcon;
import obp.simulation.resource.SimulationResources;

public class TreeConfigurationViewer
implements ConfigurationViewer {
    private InteractiveSimulator simulator;
    private JPanel treeViewer = new JPanel();
    private JTree tree;
    private DefaultTreeModel treeModel;
    private List<ObserverDialog> observerList = new ArrayList<ObserverDialog>();

    public TreeConfigurationViewer(InteractiveSimulator simulator) {
        this.simulator = simulator;
    }

    @Override
    public Component buildComponent() {
        this.treeModel = new DefaultTreeModel(null);
        this.tree = new JTree();
        this.tree.setModel(this.treeModel);
        this.tree.setCellRenderer(new ConfigurationTreeRenderer());
        this.tree.setShowsRootHandles(true);
        this.tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                NodeWithIcon nodeInfo;
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)TreeConfigurationViewer.this.tree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node.getUserObject() instanceof NodeWithIcon && (nodeInfo = (NodeWithIcon)node.getUserObject()).getObs() != null) {
                    nodeInfo.getObs().setVisible(true);
                }
            }
        });
        this.treeViewer.setLayout(new BorderLayout());
        this.treeViewer.add(this.tree);
        return new JScrollPane(this.tree);
    }

    @Override
    public void updateComponent(Configuration conf) {
        this.treeModel.setRoot(this.configToTree(conf));
        this.treeModel.reload();
        this.expandAll(this.tree);
    }

    public void expandAll(JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        this.expandOrCollapsePath(tree, new TreePath(root), true);
    }

    public void collapseAll(JTree tree) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)tree.getModel().getRoot();
        this.expandOrCollapsePath(tree, new TreePath(root), false);
    }

    public void expandOrCollapsePath(JTree tree, TreePath parent, boolean expand) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> enm = node.children();
            while (enm.hasMoreElements()) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)enm.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandOrCollapsePath(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public DefaultMutableTreeNode configToTree(Configuration configuration) {
        ConcreteContext cc;
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new NodeWithIcon("config: " + configuration.id, SimulationResources.configIcon));
        DefaultMutableTreeNode compNode = new DefaultMutableTreeNode(new NodeWithIcon("Components", SimulationResources.componentIcon));
        DefaultMutableTreeNode procNode = new DefaultMutableTreeNode(new NodeWithIcon("Processes", SimulationResources.processIcon));
        DefaultMutableTreeNode obsNode = new DefaultMutableTreeNode(new NodeWithIcon("Observers", SimulationResources.observerIcon));
        DefaultMutableTreeNode contextNode = new DefaultMutableTreeNode(new NodeWithIcon("context", SimulationResources.contextIcon));
        for (int i = 0; i < this.simulator.getBehaviorCount(); ++i) {
            String behavior = this.simulator.getBehavior()[i].toStringConfiguration(configuration.behaviorConfigurations[i]);
            if (behavior.startsWith("component")) {
                DefaultMutableTreeNode component = new DefaultMutableTreeNode(new NodeWithIcon(this.simulator.getBehavior()[i].name, SimulationResources.componentIcon));
                for (String string : this.parseComponent(behavior)) {
                    component.add(new DefaultMutableTreeNode(string));
                }
                compNode.add(component);
            }
            if (behavior.startsWith("proc")) {
                DefaultMutableTreeNode proc = new DefaultMutableTreeNode(new NodeWithIcon(this.simulator.getBehavior()[i].name, SimulationResources.processIcon));
                for (String string : this.parseProcess(behavior)) {
                    proc.add(new DefaultMutableTreeNode(string));
                }
                procNode.add(proc);
            }
            if (behavior.startsWith("observer")) {
                Observer o = null;
                if (ObsConfiguration.class.isInstance(configuration.behaviorConfigurations[i])) {
                    for (Observer observer : this.simulator.getContext().getObserverList()) {
                        if (!this.simulator.getBehavior()[i].name.contains(observer.getName())) continue;
                        o = observer;
                    }
                }
                NodeWithIcon observerLeaf = new NodeWithIcon(this.simulator.getBehavior()[i].name, SimulationResources.observerIcon);
                observerLeaf.setObs(this.getObserver(o.getName()));
                DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(observerLeaf);
                observerLeaf.getObs().setState(this.getState(behavior).replace("@", ""));
                defaultMutableTreeNode.add(new DefaultMutableTreeNode(this.getState(behavior)));
                obsNode.add(defaultMutableTreeNode);
            }
            if (!behavior.startsWith("context")) continue;
            DefaultMutableTreeNode context = new DefaultMutableTreeNode(new NodeWithIcon(this.simulator.getBehavior()[i].name, SimulationResources.contextIcon));
            context.add(new DefaultMutableTreeNode(this.getState(behavior)));
            contextNode.add(context);
        }
        root.add(compNode);
        root.add(procNode);
        root.add(contextNode);
        if (!obsNode.isLeaf()) {
            root.add(obsNode);
        }
        if (configuration.dbm != null) {
            DefaultMutableTreeNode timeNode = new DefaultMutableTreeNode(new NodeWithIcon("Time", SimulationResources.clockIcon));
            timeNode.add(new DefaultMutableTreeNode(DBM.toConstrainString(configuration.dbm)));
            root.add(timeNode);
        }
        if (this.simulator.getChannelCount() > 0) {
            DefaultMutableTreeNode channelNode = new DefaultMutableTreeNode(new NodeWithIcon("Channels", SimulationResources.channelsIcon));
            for (int i = 0; i < this.simulator.getChannelCount(); ++i) {
                Channel channel = this.simulator.getChannel((short)i);
                DefaultMutableTreeNode nameNode = new DefaultMutableTreeNode(new NodeWithIcon(channel.name, SimulationResources.chanLeafIcon));
                if (channel.clockId >= 0) {
                    nameNode.add(new DefaultMutableTreeNode(channel.clockId));
                }
                channelNode.add(nameNode);
            }
            root.add(channelNode);
        }
        if ((cc = this.simulator.getContext()) != null && this.simulator.asserts.length > 0) {
            DefaultMutableTreeNode assertNode = new DefaultMutableTreeNode(new NodeWithIcon("Violated asserts", SimulationResources.assertIcon));
            for (int i = 0; i < cc.getAssertCount(); ++i) {
                if (this.simulator.asserts[i].test(configuration)) continue;
                assertNode.add(new DefaultMutableTreeNode(this.simulator.results.getAssertDescriptions()[i]));
            }
            root.add(assertNode);
        }
        return root;
    }

    public List<String> parseComponent(String component) {
        ArrayList<String> elt = new ArrayList<String>();
        try {
            Pattern p = Pattern.compile("-{1}.*\n");
            Matcher m = p.matcher(component);
            while (m.find()) {
                elt.add(component.substring(m.start() + 1, m.end() - 1));
            }
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
        }
        return elt;
    }

    public String getState(String behavior) {
        String state = "";
        try {
            Pattern p = Pattern.compile("@{1}\\w*");
            Matcher m = p.matcher(behavior);
            while (m.find()) {
                state = behavior.substring(m.start(), m.end());
            }
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
        }
        return state;
    }

    public List<String> parseProcess(String process) {
        ArrayList<String> elt = new ArrayList<String>();
        elt.add(this.getState(process));
        try {
            Pattern p = Pattern.compile("-{1}.*\n");
            Matcher m = p.matcher(process);
            while (m.find()) {
                elt.add(process.substring(m.start() + 1, m.end() - 1));
            }
        }
        catch (PatternSyntaxException pse) {
            pse.printStackTrace();
        }
        return elt;
    }

    public ObserverDialog getObserver(String name) {
        for (ObserverDialog viewer : this.observerList) {
            if (!viewer.getObserverName().matches(name)) continue;
            return viewer;
        }
        return null;
    }

    @Override
    public void setObserverList(List<ObserverDialog> obsViewerList) {
        this.observerList = obsViewerList;
    }
}

