/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.NamedElement;
import obp.if2.data.constants.ConstantLiteral;
import obp.if2.structure.Signal;
import obp.if2.structure.entities.Process;
import obp.if2.structure.signalroutePolicies.DelayingPolicy;
import obp.if2.structure.signalroutePolicies.DeliveringPolicy;
import obp.if2.structure.signalroutePolicies.QueuingPolicy;
import obp.if2.structure.signalroutePolicies.ReliabilityPolicy;

public class Signalroute
implements NamedElement {
    private ConstantLiteral initialInstancesNumber;
    private Process from;
    private Process to;
    private final List<Signal> signalsList = new ArrayList<Signal>();
    private QueuingPolicy queuing;
    private DeliveringPolicy delivery;
    private ReliabilityPolicy reliability;
    private DelayingPolicy delay;
    private String name;

    public ConstantLiteral getInitialInstancesNumber() {
        return this.initialInstancesNumber;
    }

    public void setInitialInstancesNumber(ConstantLiteral newValue) {
        if (this.initialInstancesNumber == null ? newValue != null : !this.initialInstancesNumber.equals(newValue)) {
            this.initialInstancesNumber = newValue;
        }
    }

    public Process getFrom() {
        return this.from;
    }

    public void setFrom(Process newValue) {
        if (this.from == null ? newValue != null : !this.from.equals(newValue)) {
            this.from = newValue;
        }
    }

    public void setFromAndOpposite(Process newValue) {
        if (this.from != null) {
            this.from.removeOutRoutes(this);
        }
        if (newValue != null) {
            newValue.addOutRoutes(this);
        }
        this.setFrom(newValue);
    }

    public Process getTo() {
        return this.to;
    }

    public void setTo(Process newValue) {
        if (this.to == null ? newValue != null : !this.to.equals(newValue)) {
            this.to = newValue;
        }
    }

    public void setToAndOpposite(Process newValue) {
        if (this.to != null) {
            this.to.removeInRoutes(this);
        }
        if (newValue != null) {
            newValue.addInRoutes(this);
        }
        this.setTo(newValue);
    }

    public List<Signal> getSignalsList() {
        return Collections.unmodifiableList(this.signalsList);
    }

    public int getSignalsCount() {
        return this.signalsList.size();
    }

    public Signal getSignals(int index) {
        if (index < 0 || index >= this.getSignalsCount()) {
            return null;
        }
        return this.signalsList.get(index);
    }

    public void addSignals(Signal newValue) {
        this.addSignals(this.getSignalsCount(), newValue);
    }

    public void addSignals(int index, Signal newValue) {
        this.signalsList.add(index, newValue);
    }

    public Signal setSignals(int index, Signal newValue) {
        return this.signalsList.set(index, newValue);
    }

    public void addAllSignals(Collection<Signal> toAddList) {
        for (Signal newValue : toAddList) {
            this.addSignals(this.getSignalsCount(), newValue);
        }
    }

    public void removeSignals(Signal value) {
        int index = this.signalsList.indexOf(value);
        if (index >= 0) {
            this.removeSignals(index);
        }
    }

    public void removeSignals(int index) {
        this.signalsList.remove(index);
    }

    public QueuingPolicy getQueuing() {
        return this.queuing;
    }

    public void setQueuing(QueuingPolicy newValue) {
        if (this.queuing == null ? newValue != null : !this.queuing.equals(newValue)) {
            this.queuing = newValue;
        }
    }

    public DeliveringPolicy getDelivery() {
        return this.delivery;
    }

    public void setDelivery(DeliveringPolicy newValue) {
        if (this.delivery == null ? newValue != null : !this.delivery.equals(newValue)) {
            this.delivery = newValue;
        }
    }

    public ReliabilityPolicy getReliability() {
        return this.reliability;
    }

    public void setReliability(ReliabilityPolicy newValue) {
        if (this.reliability == null ? newValue != null : !this.reliability.equals(newValue)) {
            this.reliability = newValue;
        }
    }

    public DelayingPolicy getDelay() {
        return this.delay;
    }

    public void setDelay(DelayingPolicy newValue) {
        if (this.delay == null ? newValue != null : !this.delay.equals(newValue)) {
            this.delay = newValue;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    @Override
    public void accept(If2Visitor visitor) {
        visitor.visitSignalroute(this);
    }
}

