/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.system;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.xid.basics.error.Diagnostic;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.system.BatchCommand;

public class BasicShell {
    private ErrorHandler defaultErrorHandler = new ErrorHandler(){

        @Override
        public void handleError(Diagnostic diagnostic) {
            BasicShell.this.printOut(diagnostic.toString());
        }

        @Override
        public void handleError(int type, String message) {
            this.handleError(new Diagnostic.Stub(type, message));
        }
    };
    private File workingDirectory;
    private PrintWriter out;
    private PrintWriter err;
    private ErrorHandler errorHandler = null;
    private boolean verbose = true;

    public BasicShell(File startDirectory, PrintWriter out) {
        this(startDirectory, out, out);
    }

    public BasicShell(File startDirectory, PrintWriter out, PrintWriter err) {
        this.workingDirectory = startDirectory == null ? new File(".") : startDirectory;
        this.out = out;
        this.err = err;
    }

    private boolean hasFlag(int mask, int flags) {
        return (flags & mask) != 0;
    }

    public boolean cd(String path) {
        File tempWd;
        if (path == null) {
            return false;
        }
        File pathFile = new File(path);
        File file = tempWd = pathFile.isAbsolute() ? pathFile : new File(this.workingDirectory, path);
        if (!(tempWd.exists() && tempWd.canRead() && tempWd.isDirectory())) {
            return false;
        }
        this.workingDirectory = tempWd;
        return true;
    }

    public File pwd() {
        return this.workingDirectory;
    }

    public List<File> ls(String filter, int flags) {
        return this.ls(this.pwd(), filter, flags);
    }

    public List<File> ls(String file, String filter, int flags) {
        return this.ls(new File(file), filter, flags);
    }

    public List<File> ls(File file, String filter, int flags) {
        Pattern filterPattern = filter == null ? null : Pattern.compile(filter);
        ArrayList<File> result = new ArrayList<File>();
        if (file.isDirectory()) {
            File[] listFiles;
            for (File child : listFiles = file.listFiles()) {
                this.internalLs(child, filterPattern, flags, result);
            }
            if (this.select(file, filterPattern, flags)) {
                result.add(file);
            }
        } else {
            this.internalLs(file, filterPattern, flags, result);
        }
        return result;
    }

    private void internalLs(File file, Pattern filterPattern, int flags, List<File> result) {
        if (file.isDirectory() && this.hasFlag(8, flags)) {
            for (File child : file.listFiles()) {
                if (!this.hasFlag(16, flags) && this.isHidden(child)) continue;
                this.internalLs(child, filterPattern, flags, result);
            }
            if (this.select(file, filterPattern, flags)) {
                result.add(file);
            }
        } else if (this.select(file, filterPattern, flags)) {
            result.add(file);
        }
    }

    public void cp(String source, String destination, String filter, int flags) {
        this.cp(new File(source), new File(destination), filter, flags);
    }

    public void cp(File source, File destination, String filter, int flags) {
        if (!source.isAbsolute()) {
            source = new File(this.pwd(), source.getPath());
        }
        if (!destination.isAbsolute()) {
            destination = new File(this.pwd(), destination.getPath());
        }
        if (!source.exists()) {
            this.getErrorHandler().handleError(2, "Copy source " + source + " doesn't exist.");
            return;
        }
        if (!destination.exists() && !this.hasFlag(32, flags)) {
            return;
        }
        List<File> toCopy = this.ls(source, filter, flags);
        int sourcePathLength = source.getPath().length();
        for (File current : toCopy) {
            if (current.isDirectory()) continue;
            String delta = current.getName();
            if (sourcePathLength < current.getPath().length()) {
                delta = current.getPath().substring(sourcePathLength);
            }
            try {
                this.copyFile(current, new File(destination, delta), this.hasFlag(16, flags));
            }
            catch (Exception e) {
                this.getErrorHandler().handleError(2, e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File sourceFile, File destinationFile, boolean overwrite) throws IOException {
        if (!destinationFile.exists() || overwrite) {
            destinationFile.getParentFile().mkdirs();
            FileInputStream inputStream = new FileInputStream(sourceFile);
            FileOutputStream outputStream = new FileOutputStream(destinationFile);
            try {
                byte[] buf = new byte[2048];
                int i = 0;
                while ((i = inputStream.read(buf)) != -1) {
                    outputStream.write(buf, 0, i);
                }
            }
            finally {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            this.printOut("File " + sourceFile + " copied to " + destinationFile + " (overwrite is " + overwrite + ")");
        }
    }

    public void rm(String file, String filter, int flags) {
        this.rm(new File(file), filter, flags);
    }

    public void rm(File file, String filter, int flags) {
        if (!file.isAbsolute()) {
            file = new File(this.pwd(), file.getPath());
        }
        if (!file.exists()) {
            this.getErrorHandler().handleError(2, "Remove file " + file + " doesn't exist.");
            return;
        }
        List<File> toRemove = this.ls(file, filter, flags);
        for (File current : toRemove) {
            if (current.delete()) {
                this.printOut("File " + current + " removed.");
                continue;
            }
            this.printOut("File " + current + " wasn't removed.");
        }
    }

    private boolean isHidden(File file) {
        return file.isHidden() || file.getName().startsWith(".");
    }

    private boolean select(File file, Pattern filter, int flags) {
        if (!this.hasFlag(16, flags) && this.isHidden(file)) {
            return false;
        }
        return filter == null || filter.matcher(file.getName()).find();
    }

    public boolean exec(String command) {
        this.printOut("Exec: " + command);
        return BatchCommand.execute(command, this.pwd(), this.out, this.err);
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler == null ? this.defaultErrorHandler : this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public PrintWriter getOut() {
        return this.out;
    }

    public void setOut(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getErr() {
        return this.err;
    }

    public void setErr(PrintWriter err) {
        this.err = err;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void printOut(String message) {
        if (!this.isVerbose()) {
            return;
        }
        this.out.println(message);
        this.out.flush();
    }

    public void printErr(String message) {
        this.err.println(message);
        this.err.flush();
    }
}

