/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import obp.explorer.runtime.simulation.InteractiveSimulator;
import obp.simulation.component.ConfigurationPanel;
import obp.simulation.component.Console;
import obp.simulation.component.DiagramePanel;
import obp.simulation.component.GraphicsPanel;
import obp.simulation.component.SimulationMenu;
import obp.simulation.component.StateLinePanel;
import obp.simulation.component.ToolBar;
import obp.simulation.component.TraceDialog;
import obp.simulation.component.TransitionPanel;
import obp.simulation.resource.SimulationResources;
import obp.ui.sequence.Sequence;

public class SimulationView
extends JFrame {
    private static final long serialVersionUID = 1L;
    private InteractiveSimulator simulator;
    private SimulationMenu menu;
    private ToolBar toolBar;
    private TransitionPanel transitionPanel;
    private ConfigurationPanel configurationPanel;
    private DiagramePanel diagramPanel;
    private GraphicsPanel graphicsPanel;
    private Console console;
    private StateLinePanel stateLinePanel;
    private TraceDialog traceDialog;

    public SimulationView(String title, InteractiveSimulator simulator, File dotGraphFile) {
        super(title);
        this.simulator = simulator;
        this.init();
        this.setVisible(true);
    }

    public void init() {
        try {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", "OBP Simulator");
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        this.setIconImage(SimulationResources.simulationIcon.getImage());
        this.setDefaultCloseOperation(2);
        this.setSize(800, 650);
        JPanel tool = new JPanel();
        JPanel container = new JPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)tool, "North");
        this.add(container);
        tool.setLayout(new FlowLayout(0));
        container.setLayout(new BorderLayout());
        this.menu = new SimulationMenu();
        this.setJMenuBar(this.menu);
        this.toolBar = new ToolBar();
        tool.add(this.toolBar);
        this.transitionPanel = new TransitionPanel();
        this.configurationPanel = new ConfigurationPanel(this.simulator);
        JSplitPane splitPane2 = new JSplitPane(1, this.transitionPanel, this.configurationPanel);
        splitPane2.setAutoscrolls(true);
        splitPane2.setDividerLocation(200);
        splitPane2.setDividerSize(3);
        this.graphicsPanel = new GraphicsPanel();
        this.diagramPanel = new DiagramePanel(new Sequence());
        this.stateLinePanel = new StateLinePanel(this.simulator);
        JTabbedPane tabbedDiagram = new JTabbedPane();
        tabbedDiagram.setAutoscrolls(true);
        tabbedDiagram.addTab("Sequence diagram", this.diagramPanel);
        tabbedDiagram.addTab("State Line", this.stateLinePanel);
        JSplitPane splitPane3 = new JSplitPane(1, splitPane2, tabbedDiagram);
        splitPane3.setAutoscrolls(true);
        splitPane3.setDividerLocation(480);
        splitPane3.setDividerSize(3);
        JTabbedPane bottom = new JTabbedPane();
        bottom.setAutoscrolls(true);
        this.console = new Console();
        bottom.addTab("Console", SimulationResources.consoleIcon, new JScrollPane(this.console));
        bottom.addTab("Graphe", SimulationResources.graphIcon, new JScrollPane(this.graphicsPanel));
        JSplitPane splitPane1 = new JSplitPane(0, splitPane3, bottom);
        splitPane1.setAutoscrolls(true);
        splitPane1.setDividerLocation(400);
        splitPane1.setDividerSize(3);
        container.add((Component)splitPane1, "Center");
        this.traceDialog = new TraceDialog(this);
        this.addNotify();
        this.diagramPanel.init();
    }

    public void openTraceDialog() {
        this.traceDialog.setVisible(true);
    }

    public TraceDialog getTraceDialog() {
        return this.traceDialog;
    }

    public TransitionPanel getTransitionPanel() {
        return this.transitionPanel;
    }

    public ConfigurationPanel getConfigurationPanel() {
        return this.configurationPanel;
    }

    public Console getConsole() {
        return this.console;
    }

    public GraphicsPanel getGraphicsPanel() {
        return this.graphicsPanel;
    }

    public SimulationMenu getMenu() {
        return this.menu;
    }

    public ToolBar getToolBar() {
        return this.toolBar;
    }

    public DiagramePanel getDiagramPanel() {
        return this.diagramPanel;
    }

    public StateLinePanel getStateLinePanel() {
        return this.stateLinePanel;
    }
}

