/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.interpreter.ITransition;
import obp.interpreter.InterpreterVisitor;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public class IBehavior
implements BoostObject {
    private String name;
    private final List<String> valueList = new ArrayList<String>();
    private final List<String> initializerList = new ArrayList<String>();
    private final List<String> triggerList = new ArrayList<String>();
    private final List<ITransition> transitionList = new ArrayList<ITransition>();

    public IBehavior() {
    }

    protected IBehavior(Boost boost) {
        boost.register((BoostObject)this);
        this.name = boost.readString();
        for (String oneChild : BoostUtil.readStringArray((Boost)boost)) {
            this.valueList.add(oneChild);
        }
        for (String oneChild : BoostUtil.readStringArray((Boost)boost)) {
            this.initializerList.add(oneChild);
        }
        for (String oneChild : BoostUtil.readStringArray((Boost)boost)) {
            this.triggerList.add(oneChild);
        }
        for (ITransition oneChild : BoostUtil.readObjectList((Boost)boost, ITransition.class)) {
            this.transitionList.add(oneChild);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newValue) {
        if (this.name == null ? newValue != null : !this.name.equals(newValue)) {
            this.name = newValue;
        }
    }

    public List<String> getValueList() {
        return Collections.unmodifiableList(this.valueList);
    }

    public int getValueCount() {
        return this.valueList.size();
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.getValueCount()) {
            return null;
        }
        return this.valueList.get(index);
    }

    public void addValue(String newValue) {
        this.addValue(this.getValueCount(), newValue);
    }

    public void addValue(int index, String newValue) {
        this.valueList.add(index, newValue);
    }

    public String setValue(int index, String newValue) {
        return this.valueList.set(index, newValue);
    }

    public void addAllValue(Collection<String> toAddList) {
        for (String newValue : toAddList) {
            this.addValue(this.getValueCount(), newValue);
        }
    }

    public void removeValue(String value) {
        int index = this.valueList.indexOf(value);
        if (index >= 0) {
            this.removeValue(index);
        }
    }

    public void removeValue(int index) {
        this.valueList.remove(index);
    }

    public List<String> getInitializerList() {
        return Collections.unmodifiableList(this.initializerList);
    }

    public int getInitializerCount() {
        return this.initializerList.size();
    }

    public String getInitializer(int index) {
        if (index < 0 || index >= this.getInitializerCount()) {
            return null;
        }
        return this.initializerList.get(index);
    }

    public void addInitializer(String newValue) {
        this.addInitializer(this.getInitializerCount(), newValue);
    }

    public void addInitializer(int index, String newValue) {
        this.initializerList.add(index, newValue);
    }

    public String setInitializer(int index, String newValue) {
        return this.initializerList.set(index, newValue);
    }

    public void addAllInitializer(Collection<String> toAddList) {
        for (String newValue : toAddList) {
            this.addInitializer(this.getInitializerCount(), newValue);
        }
    }

    public void removeInitializer(String value) {
        int index = this.initializerList.indexOf(value);
        if (index >= 0) {
            this.removeInitializer(index);
        }
    }

    public void removeInitializer(int index) {
        this.initializerList.remove(index);
    }

    public List<String> getTriggerList() {
        return Collections.unmodifiableList(this.triggerList);
    }

    public int getTriggerCount() {
        return this.triggerList.size();
    }

    public String getTrigger(int index) {
        if (index < 0 || index >= this.getTriggerCount()) {
            return null;
        }
        return this.triggerList.get(index);
    }

    public void addTrigger(String newValue) {
        this.addTrigger(this.getTriggerCount(), newValue);
    }

    public void addTrigger(int index, String newValue) {
        this.triggerList.add(index, newValue);
    }

    public String setTrigger(int index, String newValue) {
        return this.triggerList.set(index, newValue);
    }

    public void addAllTrigger(Collection<String> toAddList) {
        for (String newValue : toAddList) {
            this.addTrigger(this.getTriggerCount(), newValue);
        }
    }

    public void removeTrigger(String value) {
        int index = this.triggerList.indexOf(value);
        if (index >= 0) {
            this.removeTrigger(index);
        }
    }

    public void removeTrigger(int index) {
        this.triggerList.remove(index);
    }

    public List<ITransition> getTransitionList() {
        return Collections.unmodifiableList(this.transitionList);
    }

    public int getTransitionCount() {
        return this.transitionList.size();
    }

    public ITransition getTransition(int index) {
        if (index < 0 || index >= this.getTransitionCount()) {
            return null;
        }
        return this.transitionList.get(index);
    }

    public void addTransition(ITransition newValue) {
        this.addTransition(this.getTransitionCount(), newValue);
    }

    public void addTransition(int index, ITransition newValue) {
        this.transitionList.add(index, newValue);
    }

    public ITransition setTransition(int index, ITransition newValue) {
        return this.transitionList.set(index, newValue);
    }

    public void addAllTransition(Collection<ITransition> toAddList) {
        for (ITransition newValue : toAddList) {
            this.addTransition(this.getTransitionCount(), newValue);
        }
    }

    public void removeTransition(ITransition value) {
        int index = this.transitionList.indexOf(value);
        if (index >= 0) {
            this.removeTransition(index);
        }
    }

    public void removeTransition(int index) {
        this.transitionList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        boost.writeString(this.name);
        BoostUtil.writeStringCollection((Boost)boost, this.valueList);
        BoostUtil.writeStringCollection((Boost)boost, this.initializerList);
        BoostUtil.writeStringCollection((Boost)boost, this.triggerList);
        BoostUtil.writeObjectCollection((Boost)boost, this.transitionList);
    }

    public void accept(InterpreterVisitor visitor) {
        visitor.visitIBehavior(this);
    }
}

