/*
 * Decompiled with CFR 0.152.
 */
package obp.if2.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.if2.If2Visitor;
import obp.if2.structure.PriorityRule;
import obp.if2.structure.entities.Observer;
import obp.if2.structure.entities.System;

public class IfUnit {
    private System system;
    private final List<Observer> observersList = new ArrayList<Observer>();
    private PriorityRule firstPriorityRule;

    public System getSystem() {
        return this.system;
    }

    public void setSystem(System newValue) {
        if (this.system == null ? newValue != null : !this.system.equals(newValue)) {
            this.system = newValue;
        }
    }

    public List<Observer> getObserversList() {
        return Collections.unmodifiableList(this.observersList);
    }

    public int getObserversCount() {
        return this.observersList.size();
    }

    public Observer getObservers(int index) {
        if (index < 0 || index >= this.getObserversCount()) {
            return null;
        }
        return this.observersList.get(index);
    }

    public void addObservers(Observer newValue) {
        this.addObservers(this.getObserversCount(), newValue);
    }

    public void addObservers(int index, Observer newValue) {
        this.observersList.add(index, newValue);
    }

    public Observer setObservers(int index, Observer newValue) {
        return this.observersList.set(index, newValue);
    }

    public void addAllObservers(Collection<Observer> toAddList) {
        for (Observer newValue : toAddList) {
            this.addObservers(this.getObserversCount(), newValue);
        }
    }

    public void removeObservers(Observer value) {
        int index = this.observersList.indexOf(value);
        if (index >= 0) {
            this.removeObservers(index);
        }
    }

    public void removeObservers(int index) {
        this.observersList.remove(index);
    }

    public PriorityRule getFirstPriorityRule() {
        return this.firstPriorityRule;
    }

    public void setFirstPriorityRule(PriorityRule newValue) {
        if (this.firstPriorityRule == null ? newValue != null : !this.firstPriorityRule.equals(newValue)) {
            this.firstPriorityRule = newValue;
        }
    }

    public void accept(If2Visitor visitor) {
        visitor.visitIfUnit(this);
    }
}

