/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.util;

import java.util.Stack;
import obp.fiacre.model.Array;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.BoolType;
import obp.fiacre.model.Constr;
import obp.fiacre.model.ConstrExp;
import obp.fiacre.model.Exp;
import obp.fiacre.model.Field;
import obp.fiacre.model.InlineArray;
import obp.fiacre.model.InlineQueue;
import obp.fiacre.model.InlineRecord;
import obp.fiacre.model.IntType;
import obp.fiacre.model.Interval;
import obp.fiacre.model.ModelCloner;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.NatType;
import obp.fiacre.model.Queue;
import obp.fiacre.model.Record;
import obp.fiacre.model.TypeId;
import obp.fiacre.model.Union;
import obp.fiacre.model.ValuedField;
import obp.fiacre.util.TypeUtil;

public class FiacreInitialValue
extends ModelVisitor.Stub {
    private Stack<Exp> stack = new Stack();
    private ModelCloner cloner = new ModelCloner();

    private void push(Exp e) {
        this.stack.push(e);
    }

    private Exp pop() {
        return this.stack.pop();
    }

    public Exp getInitialValue() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.pop();
    }

    @Override
    public void visitBoolType(BoolType toVisit) {
        BoolLiteral b = new BoolLiteral();
        b.setValue(false);
        this.push(b);
    }

    @Override
    public void visitNatType(NatType toVisit) {
        NatLiteral n = new NatLiteral();
        n.setValue(0);
        this.push(n);
    }

    @Override
    public void visitIntType(IntType toVisit) {
        NatLiteral n = new NatLiteral();
        n.setValue(0);
        this.push(n);
    }

    @Override
    public void visitInterval(Interval toVisit) {
        toVisit.getMini().accept(this.cloner);
        this.push((Exp)this.cloner.popObject(Exp.class));
    }

    @Override
    public void visitTypeId(TypeId toVisit) {
        toVisit.getDecl().getIs().accept(this);
    }

    @Override
    public void visitArray(Array toVisit) {
        int size = TypeUtil.computeArraySizeExpression(toVisit.getSize());
        toVisit.getType().accept(this);
        Exp initValue = this.pop();
        InlineArray ini = new InlineArray();
        for (int i = 0; i < size; ++i) {
            ini.addElem(initValue);
            initValue.accept(this.cloner);
            initValue = (Exp)this.cloner.popObject(Exp.class);
        }
        this.push(ini);
    }

    @Override
    public void visitQueue(Queue toVisit) {
        this.push(new InlineQueue());
    }

    @Override
    public void visitRecord(Record toVisit) {
        InlineRecord ini = new InlineRecord();
        for (Field f : toVisit.getFieldList()) {
            ValuedField vF = new ValuedField();
            vF.setField(f.getName());
            ini.addValue(vF);
            f.getType().accept(this);
            vF.setValue(this.pop());
        }
        this.push(ini);
    }

    @Override
    public void visitUnion(Union toVisit) {
        Constr first = toVisit.getConstr(0);
        ConstrExp ini = new ConstrExp();
        ini.setName(first.getName());
        if (first.getType() != null) {
            first.getType().accept(this);
            ini.setArg(this.pop());
        }
        this.push(ini);
    }
}

