/*
 * Decompiled with CFR 0.152.
 */
package obp2.language.state_event.diagnosis.dsl.parsing;

import obp2.language.state_event.diagnosis.dsl.grammar.SEDiagBaseListener;
import obp2.language.state_event.diagnosis.dsl.grammar.SEDiagParser;
import obp2.language.state_event.diagnosis.dsl.model.BinaryExp;
import obp2.language.state_event.diagnosis.dsl.model.ClockRef;
import obp2.language.state_event.diagnosis.dsl.model.ConditionalExp;
import obp2.language.state_event.diagnosis.dsl.model.DiagnosisExp;
import obp2.language.state_event.diagnosis.dsl.model.LiteralExp;
import obp2.language.state_event.diagnosis.dsl.model.NextVariableRef;
import obp2.language.state_event.diagnosis.dsl.model.TransitionRef;
import obp2.language.state_event.diagnosis.dsl.model.UnaryExp;
import obp2.language.state_event.diagnosis.dsl.model.VariableRef;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeProperty;
import plug.utils.parsing.TreeAnnotator;

public class ModelBuilder
extends SEDiagBaseListener
implements TreeAnnotator {
    public ParseTreeProperty<Object> values = new ParseTreeProperty();

    public ParseTreeProperty<Object> getValues() {
        return this.values;
    }

    @Override
    public void exitLiteralExp(SEDiagParser.LiteralExpContext ctx) {
        this.setValue((ParseTree)ctx, new LiteralExp(Integer.parseInt(ctx.NUMBER().getText())));
    }

    @Override
    public void exitClockExp(SEDiagParser.ClockExpContext ctx) {
        String identifier = ctx.IDENTIFIER().getText();
        identifier = identifier.substring(1, identifier.length() - 1);
        this.setValue((ParseTree)ctx, new ClockRef(identifier));
    }

    @Override
    public void exitTransitionExp(SEDiagParser.TransitionExpContext ctx) {
        String identifier = ctx.IDENTIFIER().getText();
        identifier = identifier.substring(1, identifier.length() - 1);
        int index = -1;
        try {
            index = Integer.parseInt(identifier);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("t[number] expected but found " + ctx.getText());
        }
        this.setValue((ParseTree)ctx, new TransitionRef(index));
    }

    @Override
    public void exitVariableExp(SEDiagParser.VariableExpContext ctx) {
        String identifier = ctx.IDENTIFIER().getText();
        identifier = identifier.substring(1, identifier.length() - 1);
        if (ctx.NEXT() != null) {
            this.setValue((ParseTree)ctx, new NextVariableRef(identifier));
            return;
        }
        this.setValue((ParseTree)ctx, new VariableRef(identifier));
    }

    @Override
    public void exitParenExp(SEDiagParser.ParenExpContext ctx) {
        this.setValue((ParseTree)ctx, this.getValue((ParseTree)ctx.expression()));
    }

    @Override
    public void exitUnaryExp(SEDiagParser.UnaryExpContext ctx) {
        UnaryExp.Operator operator = null;
        switch (ctx.operator.getType()) {
            case 13: {
                operator = UnaryExp.Operator.NOT;
                break;
            }
            case 15: {
                operator = UnaryExp.Operator.MINUS;
                break;
            }
        }
        DiagnosisExp operand = (DiagnosisExp)this.getValue((ParseTree)ctx.expression(), DiagnosisExp.class);
        this.setValue((ParseTree)ctx, new UnaryExp(operator, operand));
    }

    @Override
    public void exitBinaryExp(SEDiagParser.BinaryExpContext ctx) {
        BinaryExp.Operator operator = null;
        switch (ctx.operator.getType()) {
            case 16: {
                operator = BinaryExp.Operator.MULT;
                break;
            }
            case 17: {
                operator = BinaryExp.Operator.MOD;
                break;
            }
            case 14: {
                operator = BinaryExp.Operator.PLUS;
                break;
            }
            case 15: {
                operator = BinaryExp.Operator.MINUS;
                break;
            }
            case 18: {
                operator = BinaryExp.Operator.LT;
                break;
            }
            case 19: {
                operator = BinaryExp.Operator.LTE;
                break;
            }
            case 20: {
                operator = BinaryExp.Operator.GT;
                break;
            }
            case 21: {
                operator = BinaryExp.Operator.GTE;
                break;
            }
            case 22: {
                operator = BinaryExp.Operator.EQ;
                break;
            }
            case 23: {
                operator = BinaryExp.Operator.NEQ;
                break;
            }
        }
        DiagnosisExp lhs = (DiagnosisExp)this.getValue((ParseTree)ctx.expression().get(0), DiagnosisExp.class);
        DiagnosisExp rhs = (DiagnosisExp)this.getValue((ParseTree)ctx.expression().get(1), DiagnosisExp.class);
        this.setValue((ParseTree)ctx, new BinaryExp(lhs, operator, rhs));
    }

    @Override
    public void exitConditionalExp(SEDiagParser.ConditionalExpContext ctx) {
        DiagnosisExp condition = (DiagnosisExp)this.getValue((ParseTree)ctx.expression(0), DiagnosisExp.class);
        DiagnosisExp trueBranch = (DiagnosisExp)this.getValue((ParseTree)ctx.expression(1), DiagnosisExp.class);
        DiagnosisExp falseBranch = (DiagnosisExp)this.getValue((ParseTree)ctx.expression(2), DiagnosisExp.class);
        this.setValue((ParseTree)ctx, new ConditionalExp(condition, trueBranch, falseBranch));
    }
}

