/*
 * Decompiled with CFR 0.152.
 */
package obp2.algorithms.reachability;

import java.util.BitSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import obp2.algorithms.Color;
import obp2.algorithms.reachability.AbstractExplorer;
import obp2.core.IConfiguration;
import obp2.core.IStateSpaceManager;
import obp2.runtime.core.IConcurrentTransitionRelation;
import obp2.runtime.core.ITransitionRelation;

public class ConcurrentBFSExplorer<C extends IConfiguration, A>
extends AbstractExplorer<C, A> {
    protected final SharedState shared;
    public int nbThreads;

    public ConcurrentBFSExplorer(IConcurrentTransitionRelation runtime, IStateSpaceManager<C, A, Object> stateSpaceManager) {
        this(runtime, stateSpaceManager, Runtime.getRuntime().availableProcessors());
    }

    public ConcurrentBFSExplorer(IConcurrentTransitionRelation runtime, IStateSpaceManager<C, A, Object> stateSpaceManager, int nbThreads) {
        super(runtime, stateSpaceManager);
        this.nbThreads = nbThreads;
        this.shared = new SharedState(nbThreads);
    }

    @Override
    public void initializeExploration() {
        this.shared.stateSpaceManager = this.stateSpaceManager;
        super.initializeExploration();
    }

    @Override
    public boolean atEnd() {
        return this.shared.done;
    }

    protected IConcurrentTransitionRelation copyRuntime() {
        return ((IConcurrentTransitionRelation)this.getRuntime()).createCopy();
    }

    @Override
    public void explorationStep() {
        short i;
        Thread[] threads = new Thread[this.shared.N];
        for (i = 0; i < this.shared.N; i = (short)(i + 1)) {
            threads[i] = new Thread(new ExplorerThread((ITransitionRelation)this.copyRuntime(), this.stateSpaceManager, this.shared, i));
        }
        for (i = 0; i < this.shared.N; i = (short)(i + 1)) {
            threads[i].start();
        }
        this.shared.waitTheEnd();
    }

    @Override
    public C nextConfiguration() {
        return null;
    }

    @Override
    public void schedule(C conf) {
        this.setColor(conf, Color.RED);
        this.shared.toSee[0][0][0].add(conf);
    }

    protected static class ExplorerThread<C extends IConfiguration, A>
    extends AbstractExplorer<C, A>
    implements Runnable {
        public final SharedState shared;
        public final short myId;
        public short myT;
        public short currentQ;

        public ExplorerThread(ITransitionRelation runtime, IStateSpaceManager<C, A, Object> stateSpaceManager, SharedState shared, short id) {
            super(runtime, stateSpaceManager);
            this.shared = shared;
            this.myId = id;
        }

        @Override
        public void run() {
            this.myT = this.shared.t;
            do {
                this.currentQ = 0;
                while (this.currentQ < this.shared.N) {
                    this.execute();
                    this.currentQ = (short)(this.currentQ + 1);
                }
                this.shared.idle.set(this.myId);
                if (this.myId == 0) {
                    this.shared.idle.waitUntilFull();
                    this.shared.whenAllIdle();
                    continue;
                }
                this.shared.waitEndRound(this.myT);
                this.myT = this.shared.t;
            } while (!this.shared.done);
        }

        @Override
        public void initializeExploration() {
        }

        @Override
        public boolean atEnd() {
            return this.shared.toSee[this.shared.t][this.myId][this.currentQ].isEmpty();
        }

        @Override
        public C nextConfiguration() {
            return (C)((IConfiguration)this.shared.toSee[this.shared.t][this.myId][this.currentQ].remove());
        }

        @Override
        public void schedule(C conf) {
            this.setColor(conf, Color.RED);
            int threadId = this.shared.random.nextInt(this.shared.N);
            this.shared.toSee[1 - this.shared.t][threadId][this.myId].add(conf);
        }
    }

    protected static class SharedState {
        public Queue[][][] toSee;
        public boolean done = false;
        public IdleSet idle;
        public short t = 0;
        public int N;
        public IStateSpaceManager stateSpaceManager;
        public Random random = new Random();

        public SharedState(int nbThreads) {
            this.idle = new IdleSet(nbThreads);
            this.toSee = new Queue[2][nbThreads][nbThreads];
            for (int i = 0; i < 2; ++i) {
                for (int j = 0; j < nbThreads; ++j) {
                    for (int k = 0; k < nbThreads; ++k) {
                        this.toSee[i][j][k] = new LinkedList();
                    }
                }
            }
            this.N = nbThreads;
        }

        public synchronized void waitEndRound(int myT) {
            while (this.t == myT && !this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        public synchronized void whenAllIdle() {
            if (this.idle.set.cardinality() == this.N) {
                this.done = true;
                for (int i = 0; i < this.N; ++i) {
                    for (int j = 0; j < this.N; ++j) {
                        if (this.toSee[1 - this.t][i][j].isEmpty()) continue;
                        this.done = false;
                        break;
                    }
                    if (!this.done) break;
                }
                if (!this.done) {
                    this.idle.set.clear();
                    this.t = (short)(1 - this.t);
                }
                this.notifyAll();
            }
        }

        public synchronized void waitTheEnd() {
            while (!this.done) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    protected static class IdleSet {
        public final BitSet set;
        private final int size;

        public IdleSet(int size) {
            this.set = new BitSet(size);
            this.size = size;
        }

        public synchronized void set(int myId) {
            this.set.set(myId);
            if (this.set.cardinality() == this.size) {
                this.notifyAll();
            }
        }

        public synchronized void waitUntilFull() {
            while (this.set.cardinality() != this.size) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

