/*
 * Decompiled with CFR 0.152.
 */
package obp.explorer.runtime.buchi;

import java.util.ArrayList;
import java.util.List;
import obp.buchi.BuchiAutomaton;
import obp.buchi.State;
import obp.buchi.Transition;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.BehaviorConfiguration;
import obp.explorer.runtime.Configuration;
import obp.explorer.runtime.ExplorationContext;
import obp.explorer.runtime.SymbolsTable;
import obp.explorer.runtime.buchi.BuchiConfiguration;
import obp.explorer.runtime.buchi.BuchiTransition;
import obp.explorer.runtime.evaluator.Evaluator;
import obp.explorer.runtime.evaluator.Tester;
import obp.explorer.runtime.fiacre.PredicateToEvaluator;
import obp.predicate.AllPredicate;
import obp.predicate.Predicate;
import org.xid.basics.serializer.Boost;

public class BuchiBehavior
extends Behavior {
    private final BuchiAutomaton automaton;
    private BuchiTransition[] transitions;

    public BuchiBehavior(BuchiAutomaton automaton, SymbolsTable symbols) {
        super(symbols.newBehaviorName(automaton.getName(), (short)1), symbols);
        this.automaton = automaton;
    }

    @Override
    public int getStateId(String name) {
        for (int i = 0; i < this.automaton.getStateCount(); i = (int)((short)(i + 1))) {
            State state = this.automaton.getState(i);
            if (!name.equals(state.getName())) continue;
            return i;
        }
        throw new IllegalArgumentException("State '" + name + "' doesn't exist in buchi automaton named '" + this.name + "'.");
    }

    @Override
    public void link(ExplorationContext context, SymbolsTable symbols) {
        try {
            ArrayList<BuchiTransition> transitionsList = new ArrayList<BuchiTransition>(this.automaton.getTransitionCount() + 1);
            for (Transition t : this.automaton.getTransitionList()) {
                short sourceState = this.getBuchiStateId(t.getSource());
                short targetState = this.getBuchiStateIdForTarget(t.getTarget());
                Tester guardTester = this.predicateToTester(t.getGuard(), context, symbols);
                BuchiTransition transition = new BuchiTransition(this.id, sourceState, guardTester, targetState);
                transitionsList.add(transition);
            }
            this.transitions = transitionsList.toArray(new BuchiTransition[transitionsList.size()]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public BuchiTransition[] getTransitions() {
        return this.transitions;
    }

    private short getBuchiStateId(State state) {
        return (short)this.automaton.getStateList().indexOf(state);
    }

    private short getBuchiStateIdForTarget(State state) {
        return (short)this.automaton.getStateList().indexOf(state);
    }

    private Tester predicateToTester(Predicate predicate, ExplorationContext context, SymbolsTable symbols) {
        if (predicate == null) {
            predicate = new AllPredicate();
        }
        Evaluator matcher = PredicateToEvaluator.toEvaluator(predicate, context, symbols);
        return new Tester(matcher);
    }

    @Override
    public BehaviorConfiguration createInitialConfiguration(Configuration conf) {
        BuchiConfiguration me = new BuchiConfiguration();
        me.state = this.getBuchiStateIdForTarget(this.automaton.getStartState());
        return me;
    }

    @Override
    public BehaviorConfiguration readConfiguration(Boost boost) {
        BuchiConfiguration me = new BuchiConfiguration();
        me.state = boost.readShort();
        return me;
    }

    @Override
    public void writeConfiguration(Boost boost, BehaviorConfiguration processConfiguration) {
        BuchiConfiguration obsConfiguration = (BuchiConfiguration)processConfiguration;
        boost.writeShort(obsConfiguration.state);
    }

    @Override
    public void collectBehaviors(List<Behavior> result) {
    }
}

