/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.generation.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xid.basics.generation.java.JavaContentHandler;

public class Java {
    public static final int NONE = 0;
    public static final int PRIVATE = 1;
    public static final int PROTECTED = 2;
    public static final int PUBLIC = 4;
    public static final int STATIC = 8;
    public static final int FINAL = 16;
    public static final int ABSTRACT = 32;
    public static final int TRANSIENT = 64;
    public static final int SINGLE_LINE = 1;
    public static final int MULTI_LINE = 2;
    public static final int JAVA_DOC = 3;

    public static boolean has(int flags, int test) {
        return (flags & test) != 0;
    }

    public static String printFlags(int flags) {
        StringBuilder string = new StringBuilder();
        if (Java.has(flags, 1)) {
            string.append("private ");
        }
        if (Java.has(flags, 2)) {
            string.append("protected ");
        }
        if (Java.has(flags, 4)) {
            string.append("public ");
        }
        if (Java.has(flags, 8)) {
            string.append("static ");
        }
        if (Java.has(flags, 16)) {
            string.append("final ");
        }
        if (Java.has(flags, 32)) {
            string.append("abstract ");
        }
        if (Java.has(flags, 64)) {
            string.append("transient ");
        }
        return string.toString();
    }

    public static String printList(String[] list) {
        StringBuilder builder = new StringBuilder();
        if (list != null && list.length > 0) {
            builder.append(list[0]);
            for (int i = 1; i < list.length; ++i) {
                builder.append(", ");
                builder.append(list[i]);
            }
        }
        return builder.toString();
    }

    public static String printList(Parameter[] parameters) {
        StringBuilder builder = new StringBuilder();
        if (parameters != null && parameters.length > 0) {
            builder.append(parameters[0]);
            for (int i = 1; i < parameters.length; ++i) {
                builder.append(", ");
                builder.append(parameters[i]);
            }
        }
        return builder.toString();
    }

    public static String capitalize(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 1) {
            return name.toUpperCase();
        }
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    public static void beginMain(JavaContentHandler handler) {
        handler.beginMethod(12, "void", "main", null, new Parameter(0, "String[]", "args"));
    }

    public static void generateGetterSetter(JavaContentHandler g, String javaType, String name) {
        String methodName = "get" + Java.capitalize(name);
        g.beginMethod(4, javaType, methodName, null, new Parameter[0]);
        g.codeln(0, "return " + name + ";");
        g.endMethod(methodName);
        methodName = "set" + Java.capitalize(name);
        g.beginMethod(4, "void", methodName, null, new Parameter(0, javaType, name));
        g.codeln(0, "this." + name + " = " + name + ";");
        g.endMethod(methodName);
    }

    public static void endMain(JavaContentHandler handler) {
        handler.endMethod("main");
    }

    public static List<String> splitPackageName(String name) {
        if (name == null) {
            return Collections.emptyList();
        }
        String[] parts = name.split("\\.");
        ArrayList<String> result = new ArrayList<String>(parts.length);
        for (String part : parts) {
            if (part == null || part.length() <= 0) continue;
            result.add(part);
        }
        return result;
    }

    public static class Parameter {
        public int flags;
        public String type;
        public String name;

        public Parameter(int flags, String type, String name) {
            this.flags = flags;
            this.type = type;
            this.name = name;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append(Java.printFlags(this.flags));
            builder.append(this.type);
            builder.append(" ");
            builder.append(this.name);
            return builder.toString();
        }
    }
}

