/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.model.statements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import org.cte.ABCD.ABCDVisitor;
import org.cte.ABCD.model.kernel.Statement;

public class SelectStmt
implements Statement {
    private final List<Statement> statementsList = new ArrayList<Statement>();

    public List<Statement> getStatementsList() {
        return Collections.unmodifiableList(this.statementsList);
    }

    public int getStatementsCount() {
        return this.statementsList.size();
    }

    public Statement getStatements(int index) {
        if (index < 0 || index >= this.getStatementsCount()) {
            return null;
        }
        return this.statementsList.get(index);
    }

    public void addStatements(Statement newValue) {
        this.addStatements(this.getStatementsCount(), newValue);
    }

    public void addStatements(int index, Statement newValue) {
        this.statementsList.add(index, newValue);
    }

    public Statement setStatements(int index, Statement newValue) {
        return this.statementsList.set(index, newValue);
    }

    public void addAllStatements(Collection<Statement> toAddList) {
        for (Statement newValue : toAddList) {
            this.addStatements(this.getStatementsCount(), newValue);
        }
    }

    public void removeStatements(Statement value) {
        int index = this.statementsList.indexOf(value);
        if (index >= 0) {
            this.removeStatements(index);
        }
    }

    public void removeStatements(int index) {
        this.statementsList.remove(index);
    }

    @Override
    public void accept(ABCDVisitor visitor) {
        visitor.visitSelectStmt(this);
    }

    public boolean equals(Object that) {
        return this.equalsCached(that, new IdentityHashMap<Object, Object>());
    }

    @Override
    public boolean equalsCached(Object that, IdentityHashMap<Object, Object> cache) {
        if (this == that) {
            cache.put(that, this);
            return true;
        }
        if (!(that instanceof SelectStmt)) {
            return false;
        }
        Object o1 = cache.get(this);
        if (o1 != null) {
            return o1 == that;
        }
        Object o2 = cache.get(that);
        if (o2 != null) {
            return o2 == this;
        }
        return this.equalsFeatures((SelectStmt)that, cache);
    }

    protected boolean equalsFeatures(SelectStmt that, IdentityHashMap<Object, Object> cache) {
        int l1size = 0;
        int l2size = 0;
        l1size = this.statementsList.size();
        if (l1size != (l2size = that.statementsList.size())) {
            return false;
        }
        for (int i = 0; i < l1size; ++i) {
            if (this.statementsList.get(i).equalsCached(that.statementsList.get(i), cache)) continue;
            return false;
        }
        return true;
    }
}

