/*
 * Decompiled with CFR 0.152.
 */
package obp.fiacre.compiler;

import java.util.Map;
import java.util.Stack;
import obp.explorer.runtime.util.NameUtil;
import obp.fiacre.checker.type.CArray;
import obp.fiacre.checker.type.CBool;
import obp.fiacre.checker.type.CExisting;
import obp.fiacre.checker.type.CInt;
import obp.fiacre.checker.type.CRecord;
import obp.fiacre.checker.type.CType;
import obp.fiacre.checker.type.CTypeUtil;
import obp.fiacre.checker.type.CUnion;
import obp.fiacre.compiler.AssignmentGenerator;
import obp.fiacre.compiler.ExpressionGenerator;
import obp.fiacre.compiler.ProgramGenerator;
import obp.fiacre.compiler.StatementGenerator;
import obp.fiacre.model.AnyPattern;
import obp.fiacre.model.ArrayPattern;
import obp.fiacre.model.BoolLiteral;
import obp.fiacre.model.ConstantRef;
import obp.fiacre.model.ConstrPattern;
import obp.fiacre.model.FieldPattern;
import obp.fiacre.model.ModelVisitor;
import obp.fiacre.model.NatLiteral;
import obp.fiacre.model.Pattern;
import obp.fiacre.model.Type;
import obp.fiacre.model.TypeDecl;
import obp.fiacre.model.VarRef;
import obp.fiacre.util.TypeUtil;
import org.xid.basics.generation.java.JavaContentHandler;

public class PatternGenerator
extends ModelVisitor.Stub {
    private final ProgramGenerator caller;
    private final JavaContentHandler content;
    private StringBuilder condition;
    private VarRef assignmentVarRef;
    private String assignmentExpression;
    private Stack<String> expressionStack = new Stack();
    private Stack<CType> typeStack = new Stack();

    public PatternGenerator(ProgramGenerator caller) {
        this.caller = caller;
        this.content = caller.getContent();
    }

    public Map<Type, String> getTypeNames() {
        return this.caller.getTypeNames();
    }

    public ExpressionGenerator getExpressionGenerator() {
        return this.caller.getExpressionGenerator();
    }

    public AssignmentGenerator getAssignmentGenerator() {
        return this.caller.getAssignmentGenerator();
    }

    public StatementGenerator getStatementGenerator() {
        return this.caller.getStatementGenerator();
    }

    public void generateTest(boolean first, CType type, String expression, Pattern pattern) {
        String cond = this.generateCondition(type, expression, pattern);
        int level = this.getStatementGenerator().getCurrentLevel();
        if (first) {
            this.content.codeln(level, "if (" + cond + ") {");
        } else if (pattern instanceof AnyPattern) {
            this.content.codeln(level, "} else {");
        } else {
            this.content.codeln(level, "} else if (" + cond + ") {");
        }
        if (this.assignmentVarRef != null) {
            this.getAssignmentGenerator().generateForTransition(level + 1, this.assignmentVarRef, this.assignmentExpression);
        }
    }

    public String generateCondition(CType type, String expression, Pattern pattern) {
        this.condition = new StringBuilder();
        this.assignmentVarRef = null;
        this.assignmentExpression = null;
        this.pushExpression(expression);
        this.pushType(type);
        pattern.accept(this);
        this.popExpression();
        this.popType();
        return this.condition.toString();
    }

    public void generateAssignment(CType type, String expression, Pattern pattern) {
        this.generateCondition(type, expression, pattern);
        int level = this.getStatementGenerator().getCurrentLevel();
        if (this.assignmentVarRef != null) {
            this.getAssignmentGenerator().generateForTransition(level, this.assignmentVarRef, this.assignmentExpression);
        }
    }

    @Override
    public void visitBoolLiteral(BoolLiteral toVisit) {
        this.appendAndIfNeeded();
        this.condition.append('(');
        this.condition.append(this.peekExpression());
        this.condition.append(')');
        this.condition.append(" == ");
        this.condition.append(this.getExpressionGenerator().generateForBehavior(CBool.boolType, toVisit));
    }

    @Override
    public void visitNatLiteral(NatLiteral toVisit) {
        this.appendAndIfNeeded();
        this.condition.append('(');
        this.condition.append(this.peekExpression());
        this.condition.append(')');
        this.condition.append(" == ");
        this.condition.append(this.getExpressionGenerator().generateForBehavior(CInt.intType, toVisit));
    }

    @Override
    public void visitConstantRef(ConstantRef toVisit) {
        this.appendAndIfNeeded();
        String left = "(" + this.peekExpression() + ")";
        Type type = toVisit.getDecl().getType();
        CExisting cType = new CExisting(type);
        String right = this.getExpressionGenerator().generateForBehavior(cType, toVisit);
        this.condition.append(TypeUtil.generateEqualsTest(left, right, type));
    }

    @Override
    public void visitVarRef(VarRef toVisit) {
        this.assignmentVarRef = toVisit;
        this.assignmentExpression = this.peekExpression();
    }

    @Override
    public void visitAnyPattern(AnyPattern toVisit) {
        if (this.condition.length() == 0) {
            this.condition.append("true");
        }
    }

    @Override
    public void visitArrayPattern(ArrayPattern toVisit) {
        String expression = this.peekExpression();
        CType cType = this.peekType();
        TypeDecl decl = CTypeUtil.findType(cType, this.caller.getCTypeMap());
        this.appendAndIfNeeded();
        this.condition.append('(');
        this.condition.append(expression);
        this.condition.append(".getClass()) == ");
        this.condition.append(TypeUtil.toJavaDeclaration(decl.getIs(), this.getTypeNames()));
        this.condition.append(".class");
        StringBuilder expressionBuilder = new StringBuilder();
        expressionBuilder.append(expression);
        expressionBuilder.append("[");
        expressionBuilder.append(this.getExpressionGenerator().generateForBehavior(cType, toVisit.getIndex()));
        expressionBuilder.append("]");
        this.pushExpression(expressionBuilder.toString());
        this.pushType(new CArray(cType, -1));
        toVisit.getArray().accept(this);
        this.popType();
        this.popExpression();
    }

    @Override
    public void visitFieldPattern(FieldPattern toVisit) {
        String expression = this.peekExpression();
        CType cType = this.peekType(CType.class);
        TypeDecl decl = CTypeUtil.findType(cType, this.caller.getCTypeMap());
        this.appendAndIfNeeded();
        this.condition.append('(');
        this.condition.append(expression);
        this.condition.append(".getClass()) == ");
        this.condition.append(TypeUtil.toJavaDeclaration(decl.getIs(), this.getTypeNames()));
        this.condition.append(".class");
        StringBuilder expressionBuilder = new StringBuilder();
        expressionBuilder.append(expression);
        expressionBuilder.append(".");
        expressionBuilder.append(toVisit.getField());
        this.pushExpression(expressionBuilder.toString());
        CRecord cRecord = new CRecord();
        cRecord.addField(toVisit.getField(), cType);
        this.pushType(cRecord);
        toVisit.getRecord().accept(this);
        this.popType();
        this.popExpression();
    }

    @Override
    public void visitConstrPattern(ConstrPattern toVisit) {
        String expression = this.peekExpression();
        CUnion cType = this.peekType(CUnion.class);
        TypeDecl decl = CTypeUtil.findType(cType, this.caller.getCTypeMap());
        StringBuilder javaDeclaration = new StringBuilder();
        javaDeclaration.append(TypeUtil.toJavaDeclaration(decl.getIs(), this.getTypeNames()));
        javaDeclaration.append(".");
        javaDeclaration.append(NameUtil.capName(toVisit.getName()));
        this.appendAndIfNeeded();
        this.condition.append('(');
        this.condition.append(expression);
        this.condition.append(".getClass()) == ");
        this.condition.append((CharSequence)javaDeclaration);
        this.condition.append(".class");
        if (toVisit.getArg() != null) {
            StringBuilder expressionBuilder = new StringBuilder();
            expressionBuilder.append("((");
            expressionBuilder.append((CharSequence)javaDeclaration);
            expressionBuilder.append(") ");
            expressionBuilder.append(expression);
            expressionBuilder.append(").value");
            this.pushExpression(expressionBuilder.toString());
            this.pushType(cType.getConstr(toVisit.getName()));
            toVisit.getArg().accept(this);
            this.popType();
            this.popExpression();
        }
    }

    private void appendAndIfNeeded() {
        if (this.condition.length() > 0) {
            this.condition.append(" && ");
        }
    }

    private void pushType(CType type) {
        this.typeStack.push(type);
    }

    private CType popType() {
        return this.popType(CType.class);
    }

    private <T extends CType> T popType(Class<T> kind) {
        CType type = this.typeStack.pop().resolve();
        if (!kind.isInstance(type)) {
            throw new IllegalArgumentException("Type '" + type + "' isn't a '" + kind.getSimpleName() + "'.");
        }
        return (T)((CType)kind.cast(type));
    }

    private CType peekType() {
        return this.peekType(CType.class);
    }

    private <T extends CType> T peekType(Class<T> kind) {
        CType type = this.typeStack.peek().resolve();
        if (!kind.isInstance(type)) {
            throw new IllegalArgumentException("Type '" + type + "' isn't a '" + kind.getSimpleName() + "'.");
        }
        return (T)((CType)kind.cast(type));
    }

    private void pushExpression(String expression) {
        this.expressionStack.push(expression);
    }

    private String peekExpression() {
        return this.expressionStack.peek();
    }

    private String popExpression() {
        return this.expressionStack.pop();
    }
}

