/*
 * Decompiled with CFR 0.152.
 */
package obp.transfo.cdl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import obp.LTL.model.FormulaReference;
import obp.cc.ConcreteContext;
import obp.cc.State;
import obp.cc.Transition;
import obp.cdl.Activity;
import obp.cdl.ActivityDeclaration;
import obp.cdl.ActivityReference;
import obp.cdl.AltActivity;
import obp.cdl.CDLDeclaration;
import obp.cdl.CDLUnit;
import obp.cdl.EventReference;
import obp.cdl.NullActivity;
import obp.cdl.ParActivity;
import obp.cdl.PropertyReference;
import obp.cdl.RestrictionReference;
import obp.cdl.SeqActivity;
import obp.cdl.TopActivity;
import obp.predicate.Predicate;
import obp.property.Property;
import obp.property.PropertyObserver;
import obp.transfo.cc.ConcreteContextCache;
import obp.transfo.cc.ConcreteContextTopological;
import obp.transfo.ltl.LTL2Buchi;
import obp.transfo.property.PropertyToObserver;
import obp.util.ConcreteContextUtil;

public class CDLToConcreteContext {
    public static ConcreteContext toConcreteContext(CDLUnit unit, CDLDeclaration cdl) {
        ConcreteContext init = CDLToConcreteContext.toConcreteContext(cdl.getInit());
        ConcreteContext main = CDLToConcreteContext.toConcreteContext(cdl.getMain());
        ConcreteContext result = init != null ? CDLToConcreteContext.seq(init, main) : main;
        result.setName(cdl.getName());
        for (FormulaReference formulaReference : cdl.getLtlList()) {
            LTL2Buchi ltl2buchi = new LTL2Buchi(new PrintWriter(System.out));
            result.addBuchi(ltl2buchi.toBuchi(formulaReference.getRef()));
        }
        for (PropertyReference propertyReference : cdl.getPropertyList()) {
            PropertyToObserver propertyToObserver = new PropertyToObserver(new PrintWriter(System.out));
            result.addObserver(propertyToObserver.toObserver(propertyReference.getReference()));
        }
        for (RestrictionReference restrictionReference : cdl.getRestrictionList()) {
            Property property = restrictionReference.getReference().getIs();
            if (!(property instanceof PropertyObserver)) continue;
            result.addObserver(((PropertyObserver)property).getObserver());
        }
        for (Predicate predicate : cdl.getAssertList()) {
            result.addAssert(predicate);
        }
        result.setFoldingPredicate(cdl.getFoldingPredicate());
        return ConcreteContextTopological.orderCC(result);
    }

    private static ConcreteContext toConcreteContext(Activity activity) {
        if (activity == null) {
            return null;
        }
        if (activity instanceof ActivityReference) {
            ActivityDeclaration declaration = ((ActivityReference)activity).getReference();
            ConcreteContext result = CDLToConcreteContext.toConcreteContext(declaration.getIs());
            result = CDLToConcreteContext.applyLoop(activity.getLoop(), result);
            if (activity.isAtomic()) {
                CDLToConcreteContext.applyAtomic(result);
            }
            return result;
        }
        if (activity instanceof EventReference) {
            EventReference reference = (EventReference)activity;
            ConcreteContext result = CDLToConcreteContext.createFromEventReference(reference);
            result = CDLToConcreteContext.applyLoop(activity.getLoop(), result);
            if (activity.isAtomic()) {
                CDLToConcreteContext.applyAtomic(result);
            }
            return result;
        }
        if (activity instanceof NullActivity) {
            return CDLToConcreteContext.createFromNullActivity();
        }
        if (activity instanceof TopActivity) {
            TopActivity top = (TopActivity)activity;
            ConcreteContext[] concretes = new ConcreteContext[top.getActivityCount()];
            for (int i = 0; i < top.getActivityCount(); ++i) {
                concretes[i] = CDLToConcreteContext.toConcreteContext(top.getActivity(i));
            }
            ConcreteContext result = null;
            if (activity instanceof AltActivity) {
                result = CDLToConcreteContext.alt(concretes);
            } else if (activity instanceof ParActivity) {
                result = CDLToConcreteContext.par(concretes);
            } else if (activity instanceof SeqActivity) {
                result = CDLToConcreteContext.seq(concretes);
            } else {
                System.err.println("Unsupported activity '" + activity.getClass().getSimpleName() + "'.");
                return null;
            }
            result = CDLToConcreteContext.applyLoop(activity.getLoop(), result);
            if (activity.isAtomic()) {
                CDLToConcreteContext.applyAtomic(result);
            }
            return result;
        }
        throw new RuntimeException("Unsupported activity '" + activity.getClass().getSimpleName() + "'.");
    }

    private static ConcreteContext seq(ConcreteContext ... sourceCcs) {
        if (sourceCcs.length == 0) {
            return null;
        }
        if (sourceCcs.length == 1) {
            return sourceCcs[0];
        }
        ConcreteContextCache[] sourceCaches = new ConcreteContextCache[sourceCcs.length];
        for (int i = 0; i < sourceCcs.length; ++i) {
            sourceCaches[i] = new ConcreteContextCache(sourceCcs[i]);
        }
        ConcreteContext newCc = new ConcreteContext();
        for (ConcreteContext cc : sourceCcs) {
            CDLToConcreteContext.mergeInto(cc, newCc);
        }
        newCc.setStartState(sourceCcs[0].getStartState());
        for (int i = 1; i < sourceCcs.length; ++i) {
            State stopState = sourceCcs[i - 1].getStopState();
            List<Transition> inTranstions = sourceCaches[i - 1].getInTransitions(stopState);
            for (Transition in : inTranstions) {
                in.setTarget(sourceCcs[i].getStartState());
            }
            List<Transition> outTranstions = sourceCaches[i - 1].getOutTransitions(stopState);
            for (Transition out : outTranstions) {
                out.setSource(sourceCcs[i].getStartState());
            }
            newCc.removeState(stopState);
        }
        newCc.setStopState(sourceCcs[sourceCcs.length - 1].getStopState());
        return newCc;
    }

    private static ConcreteContext alt(ConcreteContext ... sourceCcs) {
        if (sourceCcs.length == 0) {
            return null;
        }
        if (sourceCcs.length == 1) {
            return sourceCcs[0];
        }
        ConcreteContextCache[] sourceCaches = new ConcreteContextCache[sourceCcs.length];
        for (int i = 0; i < sourceCcs.length; ++i) {
            sourceCaches[i] = new ConcreteContextCache(sourceCcs[i]);
        }
        ConcreteContext newCc = new ConcreteContext();
        for (ConcreteContext cc : sourceCcs) {
            if (cc.getTransitionCount() <= 0) continue;
            CDLToConcreteContext.mergeInto(cc, newCc);
        }
        State startState = new State();
        newCc.addState(startState);
        newCc.setStartState(startState);
        State stopState = new State();
        newCc.addState(stopState);
        newCc.setStopState(stopState);
        boolean needEmptyTransition = false;
        for (int i = 0; i < sourceCcs.length; ++i) {
            if (sourceCcs[i].getTransitionCount() > 0) {
                State ccStartState = sourceCcs[i].getStartState();
                List<Transition> startInTranstions = sourceCaches[i].getInTransitions(ccStartState);
                for (Transition transition : startInTranstions) {
                    transition.setTarget(newCc.getStartState());
                }
                List<Transition> startOutTranstions = sourceCaches[i].getOutTransitions(ccStartState);
                for (Transition out : startOutTranstions) {
                    out.setSource(newCc.getStartState());
                }
                newCc.removeState(ccStartState);
                State state = sourceCcs[i].getStopState();
                List<Transition> stopInTranstions = sourceCaches[i].getInTransitions(state);
                for (Transition in3 : stopInTranstions) {
                    in3.setTarget(stopState);
                }
                List<Transition> stopOutTranstions = sourceCaches[i].getOutTransitions(state);
                for (Transition out : stopOutTranstions) {
                    out.setSource(stopState);
                }
                newCc.removeState(state);
                continue;
            }
            needEmptyTransition = true;
        }
        if (needEmptyTransition) {
            Transition empty = new Transition();
            empty.setSource(startState);
            empty.setTarget(stopState);
            newCc.addTransition(empty);
        }
        return newCc;
    }

    private static ConcreteContext par(ConcreteContext ... sourceCcs) {
        if (sourceCcs.length == 0) {
            return null;
        }
        if (sourceCcs.length == 1) {
            return sourceCcs[0];
        }
        ConcreteContextCache[] sourceCaches = new ConcreteContextCache[sourceCcs.length];
        for (int i = 0; i < sourceCcs.length; ++i) {
            sourceCaches[i] = new ConcreteContextCache(sourceCcs[i]);
        }
        ConcreteContext newCc = new ConcreteContext();
        State initialState = new State();
        newCc.addState(initialState);
        newCc.setStartState(initialState);
        LinkedList<Configuration> toSee = new LinkedList<Configuration>();
        HashMap<Configuration, State> known = new HashMap<Configuration, State>();
        State[] initialStates = new State[sourceCcs.length];
        for (int i = 0; i < sourceCcs.length; ++i) {
            initialStates[i] = sourceCcs[i].getStartState();
        }
        Configuration initialConfiguration = new Configuration(initialStates);
        known.put(initialConfiguration, initialState);
        toSee.addLast(initialConfiguration);
        while (!toSee.isEmpty()) {
            Transition newTransition;
            int j;
            State newState;
            Configuration newConfiguration;
            List<Transition> outTransitions;
            int i;
            Configuration configuration = (Configuration)toSee.removeFirst();
            State state = (State)known.get(configuration);
            int unstableIndex = -1;
            for (i = 0; i < configuration.states.length; ++i) {
                if (!configuration.states[i].isUnstable()) continue;
                if (unstableIndex >= 0) {
                    throw new IllegalArgumentException("Two unstable state at the same time, this is bad !!");
                }
                unstableIndex = i;
            }
            if (unstableIndex >= 0) {
                i = unstableIndex;
                outTransitions = sourceCaches[i].getOutTransitions(configuration.states[i]);
                for (Transition transition : outTransitions) {
                    newConfiguration = new Configuration(configuration);
                    newConfiguration.states[i] = transition.getTarget();
                    newState = (State)known.get(newConfiguration);
                    if (newState == null) {
                        newState = new State();
                        newCc.addState(newState);
                        boolean stopState = true;
                        for (j = 0; j < newConfiguration.states.length; ++j) {
                            if (sourceCcs[j].getStopState().equals(newConfiguration.states[j])) continue;
                            stopState = false;
                            break;
                        }
                        if (stopState) {
                            newCc.setStopState(newState);
                        }
                        known.put(newConfiguration, newState);
                        toSee.addLast(newConfiguration);
                    }
                    newTransition = ConcreteContextUtil.copyTransition(transition);
                    newTransition.setSource(state);
                    newTransition.setTarget(newState);
                    newCc.addTransition(newTransition);
                }
                continue;
            }
            for (i = 0; i < configuration.states.length; ++i) {
                outTransitions = sourceCaches[i].getOutTransitions(configuration.states[i]);
                for (Transition transition : outTransitions) {
                    newConfiguration = new Configuration(configuration);
                    newConfiguration.states[i] = transition.getTarget();
                    newState = (State)known.get(newConfiguration);
                    if (newState == null) {
                        newState = new State();
                        newCc.addState(newState);
                        boolean stopState = true;
                        for (j = 0; j < newConfiguration.states.length; ++j) {
                            if (sourceCcs[j].getStopState().equals(newConfiguration.states[j])) continue;
                            stopState = false;
                            break;
                        }
                        if (stopState) {
                            newCc.setStopState(newState);
                        }
                        known.put(newConfiguration, newState);
                        toSee.addLast(newConfiguration);
                    }
                    newTransition = ConcreteContextUtil.copyTransition(transition);
                    newTransition.setSource(state);
                    newTransition.setTarget(newState);
                    newCc.addTransition(newTransition);
                }
            }
        }
        return newCc;
    }

    private static ConcreteContext applyLoop(int loop, ConcreteContext context) {
        if (loop <= 1) {
            return context;
        }
        ConcreteContext[] occurrenceSequence = new ConcreteContext[loop];
        occurrenceSequence[0] = context;
        for (int i = 1; i < loop; ++i) {
            occurrenceSequence[i] = ConcreteContextUtil.copyConcreteContext(context);
        }
        return CDLToConcreteContext.seq(occurrenceSequence);
    }

    private static void applyAtomic(ConcreteContext context) {
        for (State state : context.getStateList()) {
            if (state == context.getStartState() || state == context.getStopState()) continue;
            state.setUnstable(true);
        }
    }

    private static void mergeInto(ConcreteContext source, ConcreteContext target) {
        for (State state : source.getStateList()) {
            target.addState(state);
        }
        for (Transition transition : source.getTransitionList()) {
            target.addTransition(transition);
        }
    }

    private static ConcreteContext createFromEventReference(EventReference reference) {
        ConcreteContext newCc = new ConcreteContext();
        State startState = new State();
        newCc.addState(startState);
        newCc.setStartState(startState);
        State stopState = new State();
        newCc.addState(stopState);
        newCc.setStopState(stopState);
        Transition transition = new Transition();
        transition.setSource(startState);
        transition.setAction(reference);
        transition.setTarget(stopState);
        newCc.addTransition(transition);
        return newCc;
    }

    private static ConcreteContext createFromNullActivity() {
        ConcreteContext newCc = new ConcreteContext();
        State startState = new State();
        newCc.addState(startState);
        newCc.setStartState(startState);
        newCc.setStopState(startState);
        return newCc;
    }

    private static class Configuration {
        final State[] states;

        Configuration(State[] states) {
            this.states = states;
        }

        Configuration(Configuration other) {
            this(Arrays.copyOf(other.states, other.states.length));
        }

        public int hashCode() {
            return Arrays.hashCode(this.states);
        }

        public boolean equals(Object obj) {
            if (obj instanceof Configuration) {
                Configuration other = (Configuration)obj;
                return Arrays.equals(this.states, other.states);
            }
            return false;
        }
    }
}

