/*
 * Decompiled with CFR 0.152.
 */
package obp.simulation.component;

import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JToolBar;
import obp.simulation.listener.DelayChangeListener;
import obp.simulation.resource.SimulationResources;

public class ToolBar
extends JToolBar {
    private static final long serialVersionUID = 959233822909368118L;
    ArrayList<JButton> buttonList = new ArrayList();
    private JLabel contexte;
    private JButton restart;
    private JButton next;
    private JButton previous;
    private JButton nextRandom;
    private JButton start;
    private JButton pause;
    private JButton stop;
    private JSlider delay;

    public ToolBar() {
        this.initToolBar();
    }

    public void initToolBar() {
        this.restart = new JButton(SimulationResources.restartIcon);
        this.restart.setActionCommand("restart");
        this.addButton(this.restart);
        this.previous = new JButton(SimulationResources.previousIcon);
        this.previous.setActionCommand("previous");
        this.addButton(this.previous);
        this.next = new JButton(SimulationResources.nextIcon);
        this.next.setActionCommand("next");
        this.addButton(this.next);
        this.nextRandom = new JButton(SimulationResources.nextRandomIcon);
        this.nextRandom.setActionCommand("nextRandom");
        this.addButton(this.nextRandom);
        this.addSeparator();
        this.start = new JButton(SimulationResources.startIcon);
        this.start.setActionCommand("start");
        this.addButton(this.start);
        this.pause = new JButton(SimulationResources.pauseIcon);
        this.pause.setActionCommand("pause");
        this.pause.setEnabled(false);
        this.addButton(this.pause);
        this.stop = new JButton(SimulationResources.stopIcon);
        this.stop.setActionCommand("stop");
        this.stop.setEnabled(false);
        this.addButton(this.stop);
        this.delay = new JSlider(0, 1, 5, 1);
        this.delay.setEnabled(false);
        this.delay.setMinorTickSpacing(1);
        this.delay.setMajorTickSpacing(5);
        this.delay.setPaintTicks(true);
        this.delay.setPaintLabels(true);
        this.delay.setLabelTable(this.delay.createStandardLabels(1));
        this.add(this.delay);
        this.addSeparator();
        this.contexte = new JLabel("");
        this.add(this.contexte);
    }

    public void addButton(JButton button) {
        this.add(button);
        this.buttonList.add(button);
    }

    public void addListener(ActionListener al) {
        for (JButton button : this.buttonList) {
            button.addActionListener(al);
        }
    }

    public void setContexte(String contexte) {
        this.contexte.setText("contexte: " + contexte);
    }

    public void addDelayListener(DelayChangeListener dcl) {
        this.delay.addChangeListener(dcl);
    }

    public void startAction() {
        this.start.setEnabled(false);
        this.restart.setEnabled(false);
        this.next.setEnabled(false);
        this.previous.setEnabled(false);
        this.nextRandom.setEnabled(false);
        this.delay.setEnabled(true);
        this.pause.setEnabled(true);
        this.stop.setEnabled(true);
    }

    public void pauseAction() {
        this.pause.setEnabled(false);
        this.delay.setEnabled(false);
        this.start.setEnabled(true);
        this.stop.setEnabled(true);
        this.restart.setEnabled(true);
        this.next.setEnabled(true);
        this.previous.setEnabled(true);
        this.nextRandom.setEnabled(true);
    }

    public void stopAction() {
        this.start.setEnabled(true);
        this.restart.setEnabled(true);
        this.next.setEnabled(true);
        this.previous.setEnabled(true);
        this.nextRandom.setEnabled(true);
        this.pause.setEnabled(false);
        this.stop.setEnabled(false);
        this.delay.setEnabled(false);
    }
}

