/*
 * Decompiled with CFR 0.152.
 */
package obp.predicate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import obp.cdl.Option;
import obp.predicate.PredicateVisitor;
import org.xid.basics.serializer.Boost;
import org.xid.basics.serializer.BoostObject;
import org.xid.basics.serializer.BoostUtil;

public abstract class Predicate
implements BoostObject {
    private final List<Option> optionList = new ArrayList<Option>();

    public Predicate() {
    }

    protected Predicate(Boost boost) {
        boost.register((BoostObject)this);
        for (Option oneChild : BoostUtil.readObjectList((Boost)boost, Option.class)) {
            this.optionList.add(oneChild);
        }
    }

    public List<Option> getOptionList() {
        return Collections.unmodifiableList(this.optionList);
    }

    public int getOptionCount() {
        return this.optionList.size();
    }

    public Option getOption(int index) {
        if (index < 0 || index >= this.getOptionCount()) {
            return null;
        }
        return this.optionList.get(index);
    }

    public void addOption(Option newValue) {
        this.addOption(this.getOptionCount(), newValue);
    }

    public void addOption(int index, Option newValue) {
        this.optionList.add(index, newValue);
    }

    public Option setOption(int index, Option newValue) {
        return this.optionList.set(index, newValue);
    }

    public void addAllOption(Collection<Option> toAddList) {
        for (Option newValue : toAddList) {
            this.addOption(this.getOptionCount(), newValue);
        }
    }

    public void removeOption(Option value) {
        int index = this.optionList.indexOf(value);
        if (index >= 0) {
            this.removeOption(index);
        }
    }

    public void removeOption(int index) {
        this.optionList.remove(index);
    }

    public void writeToBoost(Boost boost) {
        BoostUtil.writeObjectCollection((Boost)boost, this.optionList);
    }

    public abstract void accept(PredicateVisitor var1);
}

