/*
 * Decompiled with CFR 0.152.
 */
package obp.partition;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import obp.cc.ConcreteContext;
import obp.cc.State;
import obp.cc.Transition;
import obp.partition.ConcreteContextPartitioner;
import obp.transfo.cc.ConcreteContextCache;
import obp.util.ConcreteContextUtil;

public class SimplePartitioner
extends ConcreteContextPartitioner {
    private final Stack<ConcreteContextUtil.Context> contextStack = new Stack();
    private int count;
    private final ConcreteContext cc;
    private final ConcreteContextCache cache;
    private final int splitDepth;

    public SimplePartitioner(ConcreteContext cc) {
        this(cc, 1);
    }

    public SimplePartitioner(ConcreteContext cc, int splitDepth) {
        this.cc = cc;
        this.splitDepth = splitDepth;
        this.count = 0;
        this.cache = new ConcreteContextCache(cc);
        this.contextStack.push(new ConcreteContextUtil.Context(cc.getStartState(), -1));
    }

    public int getSplitDepth() {
        return this.splitDepth;
    }

    @Override
    public boolean hasNext() {
        return !this.contextStack.isEmpty();
    }

    @Override
    public ConcreteContext next() {
        List<Transition> outTransitions;
        Transition nextTransition;
        if (!this.hasNext()) {
            throw new IndexOutOfBoundsException("No more partition available.");
        }
        boolean goalReached = false;
        while (!this.contextStack.isEmpty() && !goalReached) {
            ConcreteContextUtil.Context current = this.contextStack.peek();
            ++current.transitionIndex;
            List<Transition> outTransitions2 = this.cache.getOutTransitions(current.state);
            if (current.transitionIndex < outTransitions2.size()) {
                Transition ccTransition = outTransitions2.get(current.transitionIndex);
                int depth = 0;
                for (ConcreteContextUtil.Context oneContext : this.contextStack) {
                    if (this.cache.getOutTransitions(oneContext.state).size() <= 1) continue;
                    ++depth;
                }
                boolean bl = goalReached = depth >= this.splitDepth;
                if (this.cc.getStopState().equals(ccTransition.getTarget()) || goalReached) continue;
                this.contextStack.add(new ConcreteContextUtil.Context(ccTransition.getTarget(), -1));
                continue;
            }
            this.contextStack.pop();
        }
        ConcreteContext next = new ConcreteContext();
        ConcreteContextUtil.copyObserversAndAsserts(this.cc, next);
        next.setName(this.cc.getName() + "_" + this.count++);
        HashMap<State, State> stateMap = new HashMap<State, State>();
        State startNextState = ConcreteContextUtil.copyState(this.cc.getStartState());
        next.addState(startNextState);
        next.setStartState(startNextState);
        stateMap.put(this.cc.getStartState(), startNextState);
        State currentCcState = this.cc.getStartState();
        State currentNextState = startNextState;
        for (int i = 0; i < this.contextStack.size(); ++i) {
            ConcreteContextUtil.Context current = (ConcreteContextUtil.Context)this.contextStack.get(i);
            List<Transition> outTransitions3 = this.cache.getOutTransitions(current.state);
            Transition ccTransition = outTransitions3.get(current.transitionIndex);
            nextTransition = ConcreteContextUtil.copyTransition(ccTransition);
            nextTransition.setSource(currentNextState);
            State targetNextState = ConcreteContextUtil.copyState(ccTransition.getTarget());
            next.addState(targetNextState);
            stateMap.put(ccTransition.getTarget(), targetNextState);
            nextTransition.setTarget(targetNextState);
            next.addTransition(nextTransition);
            currentCcState = ccTransition.getTarget();
            currentNextState = targetNextState;
        }
        if (this.cc.getStopState().equals(currentCcState)) {
            next.setStopState((State)stateMap.get(currentCcState));
        } else {
            LinkedList<State> toSee = new LinkedList<State>();
            toSee.addFirst(currentCcState);
            while (!toSee.isEmpty()) {
                currentCcState = (State)toSee.removeFirst();
                currentNextState = (State)stateMap.get(currentCcState);
                outTransitions = this.cache.getOutTransitions(currentCcState);
                for (Transition ccTransition : outTransitions) {
                    nextTransition = ConcreteContextUtil.copyTransition(ccTransition);
                    nextTransition.setSource(currentNextState);
                    State targetCcState = ccTransition.getTarget();
                    State targetNextState = (State)stateMap.get(targetCcState);
                    if (targetNextState == null) {
                        targetNextState = ConcreteContextUtil.copyState(targetCcState);
                        next.addState(targetNextState);
                        stateMap.put(targetCcState, targetNextState);
                        if (this.cc.getStopState().equals(targetCcState)) {
                            next.setStopState(targetNextState);
                        } else {
                            toSee.addLast(targetCcState);
                        }
                    }
                    nextTransition.setTarget(targetNextState);
                    next.addTransition(nextTransition);
                }
            }
        }
        while (!this.contextStack.isEmpty()) {
            ConcreteContextUtil.Context current = this.contextStack.peek();
            outTransitions = this.cache.getOutTransitions(current.state);
            if (current.transitionIndex + 1 < outTransitions.size()) break;
            this.contextStack.pop();
        }
        return next;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    public long expectedPartitionCount() {
        long count = 0L;
        LinkedList<ConcreteContextUtil.Context> localContextStack = new LinkedList<ConcreteContextUtil.Context>();
        localContextStack.addLast(new ConcreteContextUtil.Context(this.cc.getStartState(), -1));
        while (!localContextStack.isEmpty()) {
            ConcreteContextUtil.Context current = (ConcreteContextUtil.Context)localContextStack.peekLast();
            ++current.transitionIndex;
            List<Transition> outTransitions = this.cache.getOutTransitions(current.state);
            if (current.transitionIndex < outTransitions.size()) {
                boolean goalReached;
                Transition ccTransition = outTransitions.get(current.transitionIndex);
                int depth = 0;
                for (ConcreteContextUtil.Context oneContext : localContextStack) {
                    if (this.cache.getOutTransitions(oneContext.state).size() <= 1) continue;
                    ++depth;
                }
                boolean bl = goalReached = depth >= this.splitDepth;
                if (!this.cc.getStopState().equals(ccTransition.getTarget()) && !goalReached) {
                    localContextStack.add(new ConcreteContextUtil.Context(ccTransition.getTarget(), -1));
                    continue;
                }
                ++count;
                continue;
            }
            localContextStack.removeLast();
        }
        return count;
    }
}

