/*
 * Decompiled with CFR 0.152.
 */
package obp;

import java.io.File;
import java.io.PrintWriter;
import obp.cc.ConcreteContext;
import obp.explorer.ExplorerConfiguration;
import obp.explorer.ExplorerController;
import obp.explorer.ExplorerResult;
import obp.fiacre.compiler.FiacreCompiler;
import obp.fiacre.compiler.ProgramGenerator;
import obp.result.ExplorationResultInfo;
import obp.tool.ToolController;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.error.ErrorHandler;
import org.xid.basics.progress.ActionMonitor;
import org.xid.basics.system.BasicShell;

public class OBPController
extends ToolController {
    public static final String directoryExtension = ".obp";
    public static final String javaDirectoryName = "java";
    public static final String javaBasePackage = null;
    public static final String classDirectoryName = "bin";
    public static final String confsDirectoryName = "confs";
    private final ExplorerController explorerController;
    private final BasicShell shell;

    public OBPController(ExplorerConfiguration configuration, PrintWriter out, PrintWriter err) {
        super(out, err);
        this.explorerController = new ExplorerController(configuration, out, err);
        this.shell = new BasicShell(this.getWorkingDirectory(), out, err);
        this.shell.setVerbose(false);
    }

    @Override
    public void setWorkingDirectory(File workingDirectory) {
        super.setWorkingDirectory(workingDirectory);
        this.explorerController.setWorkingDirectory(workingDirectory);
        this.shell.cd(workingDirectory.getAbsolutePath());
    }

    @Override
    public void setEnv(String[] env) {
        super.setEnv(env);
        this.explorerController.setEnv(env);
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) {
        super.setErrorHandler(errorHandler);
        this.explorerController.setErrorHandler(errorHandler);
        this.shell.setErrorHandler(errorHandler);
    }

    @Override
    public void setVerbose(boolean verbose) {
        super.setVerbose(verbose);
        this.explorerController.setVerbose(verbose);
    }

    @Override
    public void interrupt() {
        super.interrupt();
        this.explorerController.interrupt();
    }

    @Override
    public void stop() {
        super.stop();
        this.explorerController.stop();
    }

    public void compileFiacre(File fiacreFile, ActionMonitor monitor) {
        this.scheduleClearResult();
        this.compileFiacre(fiacreFile);
        this.compileJava(fiacreFile);
        this.globalMonitor(monitor);
    }

    private void compileFiacre(final File fiacreFile) {
        this.schedule(new Runnable(){

            @Override
            public void run() {
                new FiacreCompiler().compileFiacre(fiacreFile, OBPController.directoryExtension, OBPController.javaDirectoryName, javaBasePackage, OBPController.this.shell.getOut(), OBPController.this.shell.getErr(), OBPController.this.getErrorHandler());
            }
        });
    }

    private void compileJava(final File fiacreFile) {
        this.schedule(new Runnable(){

            @Override
            public void run() {
                new FiacreCompiler().compileJava(fiacreFile, OBPController.directoryExtension, OBPController.javaDirectoryName, OBPController.classDirectoryName, OBPController.this.shell.getOut(), OBPController.this.shell.getErr(), OBPController.this.getErrorHandler());
            }
        });
    }

    public void explore(final File fiacreFile, final ConcreteContext concreteContext, final File ccslFile, final boolean saveConfigurationInFile, ActionMonitor monitor) {
        this.scheduleClearResult();
        this.schedule(new Runnable(){

            @Override
            public void run() {
                String baseName = ToolController.getBaseName(fiacreFile);
                File outputDirectory = new File(fiacreFile.getParentFile(), baseName + OBPController.directoryExtension);
                File classDirectory = new File(outputDirectory, OBPController.classDirectoryName);
                File configDirectory = null;
                if (saveConfigurationInFile && !(configDirectory = new File(outputDirectory, OBPController.confsDirectoryName)).exists()) {
                    configDirectory.mkdir();
                }
                File confsDirectory = configDirectory;
                String programQualifiedName = ProgramGenerator.getProgramQualifiedName(javaBasePackage, baseName);
                try {
                    OBPController.this.explorerController.explore(classDirectory, programQualifiedName, concreteContext, ccslFile, confsDirectory, ActionMonitor.empty);
                    OBPController.this.explorerController.join();
                    ExplorerResult explorerResult = OBPController.this.explorerController.popResult(ExplorerResult.class);
                    OBPController.this.pushResult(explorerResult);
                }
                catch (Exception e) {
                    String message = DiagnosticUtil.createMessage((Throwable)e);
                    OBPController.this.getErrorHandler().handleError(2, message + "\n");
                    throw new RuntimeException(e);
                }
            }
        });
        this.globalMonitor(monitor);
    }

    public void exploreAutoSplit(final File fiacreFile, final ConcreteContext concreteContext, final int initial, final int step, final File ccslFile, final boolean saveConfigurationInFile, ActionMonitor monitor) {
        this.scheduleClearResult();
        this.schedule(new Runnable(){

            @Override
            public void run() {
                String baseName = ToolController.getBaseName(fiacreFile);
                File outputDirectory = new File(fiacreFile.getParentFile(), baseName + OBPController.directoryExtension);
                File classDirectory = new File(outputDirectory, OBPController.classDirectoryName);
                File configDirectory = null;
                if (saveConfigurationInFile && !(configDirectory = new File(outputDirectory, OBPController.confsDirectoryName)).exists()) {
                    configDirectory.mkdir();
                }
                File confsDirectory = configDirectory;
                String programQualifiedName = ProgramGenerator.getProgramQualifiedName(javaBasePackage, baseName);
                try {
                    OBPController.this.explorerController.exploreAutoSplit(classDirectory, programQualifiedName, concreteContext, initial, step, ccslFile, confsDirectory, ActionMonitor.empty);
                    OBPController.this.explorerController.join();
                    while (OBPController.this.explorerController.hasResult()) {
                        ExplorationResultInfo explorationResultInfo = OBPController.this.explorerController.popResult(ExplorationResultInfo.class);
                        OBPController.this.pushResult(explorationResultInfo);
                    }
                }
                catch (InterruptedException e) {
                    String message = DiagnosticUtil.createMessage((Throwable)e);
                    OBPController.this.getErrorHandler().handleError(2, message + "\n");
                    throw new RuntimeException(e);
                }
            }
        });
        this.globalMonitor(monitor);
    }

    public void exploreMoCCML(final File mocfile, final boolean saveConfigurationInFile, ActionMonitor monitor) {
        this.scheduleClearResult();
        this.schedule(new Runnable(){

            @Override
            public void run() {
                File confsDirectory;
                String baseName = ToolController.getBaseName(mocfile);
                File outputDirectory = new File(mocfile.getParentFile(), baseName + OBPController.directoryExtension);
                File configDirectory = null;
                if (saveConfigurationInFile && !(configDirectory = new File(outputDirectory, OBPController.confsDirectoryName)).exists()) {
                    configDirectory.mkdir();
                }
                if (!(confsDirectory = configDirectory).exists()) {
                    confsDirectory.mkdir();
                }
                try {
                    OBPController.this.explorerController.exploreMoCCML(mocfile, ClassLoader.getSystemClassLoader().getResource(".").getPath(), configDirectory, ActionMonitor.empty);
                    OBPController.this.explorerController.join();
                    ExplorerResult explorerResult = OBPController.this.explorerController.popResult(ExplorerResult.class);
                    OBPController.this.pushResult(explorerResult);
                }
                catch (Exception e) {
                    String message = DiagnosticUtil.createMessage((Throwable)e);
                    OBPController.this.getErrorHandler().handleError(2, message + "\n");
                    throw new RuntimeException(e);
                }
            }
        });
        this.globalMonitor(monitor);
    }
}

