/*
 * Decompiled with CFR 0.152.
 */
package org.xid.basics.sexp.model;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xid.basics.error.DiagnosticUtil;
import org.xid.basics.sexp.SExp;
import org.xid.basics.sexp.SVariable;
import org.xid.basics.sexp.VariableResolver;
import org.xid.basics.sexp.model.Referencer;

public final class SExpToModel {
    private final VariableResolver resolver;
    private final Referencer referencer;
    private final Map<String, Method> referenceMethodCacheMap = new HashMap<String, Method>();
    private final ContextNode contextRoot;
    private ContextNode contextCurrent = this.contextRoot = new ContextNode(null);

    public SExpToModel(Referencer referencer) {
        this(referencer, new VariableResolver.Mapped());
    }

    public SExpToModel(Referencer referencer, VariableResolver resolver) {
        this.referencer = referencer;
        this.resolver = resolver;
        this.registerBuiltins();
    }

    private void registerBuiltins() {
        for (Map.Entry<String, Object> entry : this.referencer.builtins().entrySet()) {
            this.register(entry.getKey(), entry.getValue());
        }
    }

    private void register(String reference, Object object) {
        HashMap<String, Object> current = this.contextCurrent.objectMap;
        current.put(reference, object);
    }

    private Object resolve(String reference) {
        ContextNode iterator = this.contextCurrent;
        while (iterator != null) {
            HashMap<String, Object> current = iterator.objectMap;
            Object resolved = current.get(reference);
            if (resolved != null) {
                return resolved;
            }
            iterator = iterator.parent;
        }
        return null;
    }

    private void pushReferenceContext() {
        ContextNode contextNew;
        this.contextCurrent = contextNew = new ContextNode(this.contextCurrent);
    }

    private void popReferenceContext() {
        this.contextCurrent = this.contextCurrent.parent;
    }

    private String uniqueReference(String reference) {
        HashMap<String, Object> current = this.contextCurrent.objectMap;
        while (current.containsKey(reference)) {
            reference = reference + "_";
        }
        return reference;
    }

    public void push(Object object) throws IOException {
        String reference = this.referencer.referenceFor(object);
        reference = this.uniqueReference(reference);
        this.register(reference, object);
        ArrayList<PendingReference> toResolveList = new ArrayList<PendingReference>();
        this.contextCurrent.collectPendingReferencesFor(reference, toResolveList);
        for (PendingReference pending : toResolveList) {
            try {
                pending.method.invoke(pending.receiver, object);
            }
            catch (Exception e) {
                String message = DiagnosticUtil.createMessage(e);
                throw new IOException(message);
            }
        }
        if (this.referencer.pushContext(object)) {
            this.pushReferenceContext();
        }
    }

    public void pop(Object object) {
        if (this.referencer.popContext(object)) {
            this.popReferenceContext();
        }
    }

    public void registerReference(Object receiver, String name, boolean many, SExp sexp) throws IOException {
        if (sexp.isNull()) {
            return;
        }
        if (receiver == null || name == null) {
            return;
        }
        String prefix = many ? "add" : "set";
        String methodName = prefix + SExpToModel.upcaseFirstCharacter(name);
        Class<?> klazz = receiver.getClass();
        String methodKey = klazz.getCanonicalName() + "#" + methodName;
        Method method = this.referenceMethodCacheMap.get(methodKey);
        if (method == null) {
            for (Method oneMethod : klazz.getMethods()) {
                if (!methodName.equals(oneMethod.getName()) || oneMethod.getParameterTypes().length != 1) continue;
                method = oneMethod;
                break;
            }
            if (method == null) {
                throw new IOException("Method '" + methodName + "' not found on class '" + klazz.getSimpleName() + "'.");
            }
            this.referenceMethodCacheMap.put(methodKey, method);
        }
        Object referenced = null;
        if (sexp.isVariable()) {
            String variableName = ((SVariable)sexp).getName();
            Class<?> type = method.getParameterTypes()[0];
            referenced = this.resolver.resolve(variableName, type);
        } else {
            referenced = this.resolve(sexp.getValue());
        }
        if (referenced != null) {
            try {
                method.invoke(receiver, referenced);
            }
            catch (Exception e) {
                String message = DiagnosticUtil.createMessage(e);
                throw new IOException(message);
            }
        } else {
            this.contextCurrent.registerPendingReference(sexp.getValue(), receiver, method);
        }
    }

    public Set<String> unresolvedReferences() {
        return this.contextRoot.unresolvedReferences();
    }

    public static String upcaseFirstCharacter(String value) {
        if (value == null) {
            return null;
        }
        if (value.length() == 1) {
            return value.toUpperCase();
        }
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private class ContextNode {
        final HashMap<String, Object> objectMap = new HashMap();
        final Map<String, List<PendingReference>> pendingReferenceMap = new HashMap<String, List<PendingReference>>();
        final ContextNode parent;
        ArrayList<ContextNode> children;

        ContextNode(ContextNode parent) {
            this.parent = parent;
            if (parent != null) {
                parent.addChild(this);
            }
        }

        void addChild(ContextNode child) {
            if (this.children == null) {
                this.children = new ArrayList();
            }
            this.children.add(child);
        }

        void registerPendingReference(String reference, Object receiver, Method method) {
            List<PendingReference> toResolveList = this.pendingReferenceMap.get(reference);
            if (toResolveList == null) {
                toResolveList = new ArrayList<PendingReference>();
                this.pendingReferenceMap.put(reference, toResolveList);
            }
            toResolveList.add(new PendingReference(receiver, method));
        }

        void collectPendingReferencesFor(String reference, List<PendingReference> result) {
            List<PendingReference> pendings = this.pendingReferenceMap.get(reference);
            if (pendings != null) {
                result.addAll(pendings);
                this.pendingReferenceMap.remove(reference);
            }
            if (this.children != null) {
                for (ContextNode child : this.children) {
                    child.collectPendingReferencesFor(reference, result);
                }
            }
        }

        Set<String> unresolvedReferences() {
            HashSet<String> missing = new HashSet<String>(this.pendingReferenceMap.keySet());
            if (this.children != null) {
                for (ContextNode child : this.children) {
                    missing.addAll(child.unresolvedReferences());
                }
            }
            return missing;
        }
    }

    private class PendingReference {
        private final Object receiver;
        private final Method method;

        public PendingReference(Object receiver, Method method) {
            this.receiver = receiver;
            this.method = method;
        }
    }
}

