/*
 * Decompiled with CFR 0.152.
 */
package tla2sany.semantic;

import java.util.HashSet;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import tla2sany.explorer.ExploreNode;
import tla2sany.semantic.ArgLevelParam;
import tla2sany.semantic.Context;
import tla2sany.semantic.ExprNode;
import tla2sany.semantic.FormalParamNode;
import tla2sany.semantic.InstanceNode;
import tla2sany.semantic.LevelConstants;
import tla2sany.semantic.OpDefNode;
import tla2sany.semantic.SemanticNode;
import tla2sany.semantic.SymbolNode;
import tla2sany.st.TreeNode;
import tla2sany.utilities.Strings;
import tla2sany.utilities.Vector;
import tla2sany.xml.SymbolContext;

public class LetInNode
extends ExprNode
implements ExploreNode,
LevelConstants {
    private SymbolNode[] opDefs;
    public Context context;
    private InstanceNode[] insts;
    private ExprNode body;
    private OpDefNode[] gottenLets = null;

    public LetInNode(TreeNode treeNode, SymbolNode[] defs, InstanceNode[] insts, ExprNode bdy, Context ctext) {
        super(10, treeNode);
        this.opDefs = defs;
        this.insts = insts;
        this.body = bdy;
        this.context = ctext;
    }

    public final OpDefNode[] getLets() {
        if (this.gottenLets == null) {
            int i;
            int cnt = 0;
            for (i = 0; i < this.opDefs.length; ++i) {
                if (this.opDefs[i].getKind() != 5) continue;
                ++cnt;
            }
            this.gottenLets = new OpDefNode[cnt];
            cnt = 0;
            for (i = 0; i < this.opDefs.length; ++i) {
                if (this.opDefs[i].getKind() != 5) continue;
                this.gottenLets[cnt] = (OpDefNode)this.opDefs[i];
                ++cnt;
            }
        }
        return this.gottenLets;
    }

    public final ExprNode getBody() {
        return this.body;
    }

    @Override
    public final boolean levelCheck(int itr) {
        int i;
        if (this.levelChecked >= itr) {
            return this.levelCorrect;
        }
        this.levelChecked = itr;
        this.levelCorrect = true;
        for (i = 0; i < this.opDefs.length; ++i) {
            if (this.opDefs[i].getKind() == 6 || this.opDefs[i].levelCheck(itr)) continue;
            this.levelCorrect = false;
        }
        if (!this.body.levelCheck(itr)) {
            this.levelCorrect = false;
        }
        for (i = 0; i < this.insts.length; ++i) {
            if (this.insts[i].levelCheck(itr)) continue;
            this.levelCorrect = false;
        }
        this.level = this.body.getLevel();
        this.levelParams = (HashSet)this.body.getLevelParams().clone();
        this.allParams = (HashSet)this.body.getAllParams().clone();
        this.levelConstraints.putAll(this.body.getLevelConstraints());
        for (i = 0; i < this.opDefs.length; ++i) {
            if (this.opDefs[i].getKind() == 6) continue;
            this.levelConstraints.putAll(this.opDefs[i].getLevelConstraints());
        }
        this.argLevelConstraints.putAll(this.body.getArgLevelConstraints());
        for (i = 0; i < this.opDefs.length; ++i) {
            if (this.opDefs[i].getKind() == 6) continue;
            this.argLevelConstraints.putAll(this.opDefs[i].getArgLevelConstraints());
        }
        this.argLevelParams.addAll(this.body.getArgLevelParams());
        for (i = 0; i < this.opDefs.length; ++i) {
            if (this.opDefs[i].getKind() == 6) continue;
            SymbolNode[] params = new FormalParamNode[]{};
            if (this.opDefs[i].getKind() != 23) {
                params = ((OpDefNode)this.opDefs[i]).getParams();
            }
            for (ArgLevelParam alp : this.opDefs[i].getArgLevelParams()) {
                if (alp.occur(params)) continue;
                this.argLevelParams.add(alp);
            }
        }
        for (i = 0; i < this.insts.length; ++i) {
            this.argLevelParams.addAll(this.insts[i].getArgLevelParams());
        }
        return this.levelCorrect;
    }

    @Override
    public SemanticNode[] getChildren() {
        SemanticNode[] res = new SemanticNode[this.opDefs.length + this.insts.length + 1];
        res[res.length - 1] = this.body;
        for (int i = 0; i < this.opDefs.length; ++i) {
            res[i] = this.opDefs[i];
        }
        for (int j = 0; j < this.insts.length; ++j) {
            res[i + j] = this.insts[j];
        }
        return res;
    }

    @Override
    public final void walkGraph(Hashtable<Integer, ExploreNode> semNodesTable) {
        Integer uid = new Integer(this.myUID);
        if (semNodesTable.get(uid) != null) {
            return;
        }
        semNodesTable.put(uid, this);
        if (this.context != null) {
            this.context.walkGraph(semNodesTable);
        }
        if (this.body != null) {
            this.body.walkGraph(semNodesTable);
        }
    }

    @Override
    public final String toString(int depth) {
        if (depth <= 0) {
            return "";
        }
        String ret = "\n*LetInNode: " + super.toString(depth);
        Vector contextEntries = this.context.getContextEntryStringVector(1, false);
        if (contextEntries != null) {
            for (int i = 0; i < contextEntries.size(); ++i) {
                ret = contextEntries.elementAt(i) != null ? ret + Strings.indent(2, (String)contextEntries.elementAt(i)) : ret + "*** null ***";
            }
        }
        ret = ret + Strings.indent(2, "\nBody:" + Strings.indent(2, this.body.toString(depth - 1)));
        return ret;
    }

    @Override
    protected Element getLevelElement(Document doc, SymbolContext context) {
        Element ret = doc.createElement("LetInNode");
        ret.appendChild(this.appendElement(doc, "body", this.body.export(doc, context)));
        Element arguments = doc.createElement("opDefs");
        for (int i = 0; i < this.opDefs.length; ++i) {
            arguments.appendChild(this.opDefs[i].export(doc, context));
        }
        ret.appendChild(arguments);
        return ret;
    }
}

