/*
 * Decompiled with CFR 0.152.
 */
package org.cte.ABCD.compiler;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.cte.ABCD.model.declarations.ABCDSystem;
import org.cte.ABCD.model.declarations.NamedDeclaration;
import org.cte.ABCD.model.declarations.ParameterDecl;
import org.cte.ABCD.model.declarations.Port;
import org.cte.ABCD.model.declarations.ProcessDecl;
import org.cte.ABCD.model.declarations.ProcessInstance;

public class ProcessResolver {
    private ABCDSystem system;
    private Map<String, ProcessDecl> processHash;

    public ProcessResolver(ABCDSystem system) {
        this.system = system;
        this.processHash = new LinkedHashMap<String, ProcessDecl>();
    }

    public void resolveAndBind() {
        for (ProcessDecl pd : this.system.getProcessesList()) {
            if (this.processHash.put(pd.getName(), pd) == null) continue;
            System.err.println("Multiple definition of process (only the last one is used)" + pd.getName());
        }
        this.resolveProcesses();
    }

    private void bindParameters(ProcessDecl pD, ProcessInstance pI) {
        if (pD.getParametersCount() != pI.getArgumentsCount()) {
            System.err.println("The process " + pD.getName() + " expects " + pD.getParametersCount() + " parameters but its instantiation provides " + pI.getArgumentsCount());
        } else if (pD.getParametersCount() > 0) {
            boolean hasNamedAssociations = pI.getArguments(0).getFormalName() != null;
            for (int i = 0; i < pD.getParametersCount(); ++i) {
                String formalName = pI.getArguments(i).getFormalName();
                if (formalName != null) {
                    if (!hasNamedAssociations) {
                        System.err.println("Mixing named and unamed argument mappings during instantiation is not supported");
                        break;
                    }
                    ParameterDecl param = this.getNamedDeclaration(pD.getParametersList(), formalName, ParameterDecl.class);
                    if (param == null) {
                        System.err.println("The process '" + pD.getName() + "' does not have a parameter named '" + formalName + "'");
                        break;
                    }
                    pI.getArguments(i).setFormal(param);
                    continue;
                }
                if (hasNamedAssociations) {
                    System.err.println("Mixing named and unamed argument mappings during instantiation is not supported");
                    break;
                }
                pI.getArguments(i).setFormal(pD.getParameters(i));
            }
        }
    }

    private <T extends NamedDeclaration> T getNamedDeclaration(List<T> elements, String name, Class<T> type) {
        for (NamedDeclaration p : elements) {
            if (!p.getName().equals(name)) continue;
            return (T)((NamedDeclaration)type.cast(p));
        }
        return null;
    }

    private void bindPorts(ProcessDecl pD, ProcessInstance pI) {
        Port port;
        String formalName;
        Vector<Port> inputs = new Vector<Port>();
        Vector<Port> outputs = new Vector<Port>();
        for (Port p : pD.getPortsList()) {
            if (p.isIsInput()) {
                inputs.add(p);
                continue;
            }
            outputs.add(p);
        }
        if (inputs.size() != pI.getInputsCount()) {
            System.err.println("The process " + pD.getName() + " expects " + inputs.size() + " input channel but its instantiation provides " + pI.getInputsCount());
        } else if (inputs.size() > 0) {
            boolean hasNamedAssociations = pI.getInputs(0).getFormalName() != null;
            for (int i = 0; i < inputs.size(); ++i) {
                formalName = pI.getInputs(i).getFormalName();
                if (formalName != null) {
                    if (!hasNamedAssociations) {
                        System.err.println("Mixing named and unamed port mappings during instantiation is not supported");
                        break;
                    }
                    port = this.getNamedDeclaration(inputs, formalName, Port.class);
                    if (port == null) {
                        System.err.println("The process '" + pD.getName() + "' does not have an input port named '" + formalName + "'");
                        break;
                    }
                    pI.getInputs(i).setFormal(port);
                    continue;
                }
                if (hasNamedAssociations) {
                    System.err.println("Mixing named and unamed port mappings during instantiation is not supported");
                    break;
                }
                pI.getInputs(i).setFormal((Port)inputs.get(i));
            }
        }
        if (outputs.size() != pI.getOutputsCount()) {
            System.err.println("The process " + pD.getName() + " expects " + outputs.size() + " output channel but its instantiation provides " + pI.getOutputsCount());
        } else if (outputs.size() > 0) {
            boolean hasNamedAssociations = pI.getOutputs(0).getFormalName() != null;
            for (int i = 0; i < outputs.size(); ++i) {
                formalName = pI.getOutputs(i).getFormalName();
                if (formalName != null) {
                    if (!hasNamedAssociations) {
                        System.err.println("Mixing named and unamed port mappings during instantiation is not supported");
                        break;
                    }
                    port = this.getNamedDeclaration(outputs, formalName, Port.class);
                    if (port == null) {
                        System.err.println("The process '" + pD.getName() + "' does not have an output port named '" + formalName + "'");
                        break;
                    }
                    pI.getOutputs(i).setFormal(port);
                    continue;
                }
                if (hasNamedAssociations) {
                    System.err.println("Mixing named and unamed port mappings during instantiation is not supported");
                    break;
                }
                pI.getOutputs(i).setFormal((Port)outputs.get(i));
            }
        }
    }

    private void resolveProcesses() {
        for (ProcessInstance pI : this.system.getCompositionList()) {
            if (pI.getProcess() != null) continue;
            ProcessDecl pD = this.processHash.get(pI.getName());
            if (pD == null) {
                System.err.println("Cannot find process " + pI.getName());
                continue;
            }
            this.bindParameters(pD, pI);
            this.bindPorts(pD, pI);
            pI.setProcess(pD);
        }
    }
}

