/*
 * Decompiled with CFR 0.152.
 */
package obp.transfo.cc;

import java.util.HashMap;
import obp.cc.ConcreteContext;
import obp.cc.State;
import obp.cc.Transition;
import obp.util.EventUtil;

public class ConcreteContextExport {
    public static String toDot(ConcreteContext cc) {
        StringBuilder dot = new StringBuilder();
        dot.append("digraph ");
        if (cc.getName() != null) {
            dot.append(cc.getName());
        } else {
            dot.append("Context");
        }
        dot.append(" { \n\trankdir=TB;\n");
        HashMap<State, Integer> idMap = new HashMap<State, Integer>();
        int currentId = 0;
        for (State conf : cc.getStateList()) {
            idMap.put(conf, currentId++);
        }
        dot.append("\t");
        dot.append(idMap.get(cc.getStartState()));
        dot.append(" [peripheries=2];\n");
        dot.append("\t");
        dot.append(idMap.get(cc.getStopState()));
        dot.append(" [shape=\"box\"];\n");
        for (Transition transition : cc.getTransitionList()) {
            dot.append("\t");
            dot.append(idMap.get(transition.getSource()));
            dot.append(" -> ");
            dot.append(idMap.get(transition.getTarget()));
            dot.append(" [label=\"");
            if (transition.getAction() != null) {
                dot.append(transition.getAction().getName());
            } else {
                dot.append("tau");
            }
            dot.append("\"];\n");
        }
        dot.append("}");
        return dot.toString();
    }

    public static String toSimpleDot(ConcreteContext cc) {
        StringBuilder dot = new StringBuilder();
        dot.append("digraph ");
        if (cc.getName() != null) {
            dot.append(cc.getName());
        } else {
            dot.append("Context");
        }
        dot.append(" { \n\trankdir=TB;\n");
        dot.append("node [shape=point];\n");
        dot.append("edge [arrowhead=none,arrowtail=none];\n");
        HashMap<State, Integer> idMap = new HashMap<State, Integer>();
        int currentId = 0;
        for (State conf : cc.getStateList()) {
            idMap.put(conf, currentId++);
        }
        dot.append("\t");
        dot.append(idMap.get(cc.getStartState()));
        dot.append(" [peripheries=2];\n");
        dot.append("\t");
        dot.append(idMap.get(cc.getStopState()));
        dot.append(" [shape=\"box\"];\n");
        for (Transition transition : cc.getTransitionList()) {
            dot.append("\t");
            dot.append(idMap.get(transition.getSource()));
            dot.append(" -> ");
            dot.append(idMap.get(transition.getTarget()) + ";");
        }
        dot.append("}");
        return dot.toString();
    }

    public static String toSimple(ConcreteContext context) {
        HashMap<State, String> stateMap = new HashMap<State, String>();
        int count = 1;
        for (State sourceState : context.getStateList()) {
            stateMap.put(sourceState, "" + count);
            ++count;
        }
        StringBuilder simple = new StringBuilder();
        simple.append("(StartState=");
        simple.append((String)stateMap.get(context.getStartState()));
        simple.append(")\n");
        for (Transition transition : context.getTransitionList()) {
            simple.append("(");
            simple.append((String)stateMap.get(transition.getSource()));
            simple.append(";\"");
            if (transition.getAction() != null) {
                simple.append(EventUtil.printEvent(transition.getAction().getReference().getIs()));
            }
            simple.append("\";");
            simple.append((String)stateMap.get(transition.getTarget()));
            simple.append(")\n");
        }
        return simple.toString();
    }
}

