/*
 * Decompiled with CFR 0.152.
 */
package obp.interpreter.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import obp.explorer.runtime.Behavior;
import obp.explorer.runtime.Component;
import obp.explorer.runtime.core.Channel;
import obp.interpreter.IBehavior;
import obp.interpreter.IProgram;
import obp.interpreter.runtime.BehaviorImpl;
import obp.interpreter.runtime.InterpreterContext;
import obp.interpreter.runtime.RootBehaviorImpl;

public class RootComponentImpl
implements Component {
    private final List<Behavior> behaviors = new ArrayList<Behavior>();
    private final Channel[] channels;
    private final RootBehaviorImpl rootBehavior;

    public RootComponentImpl(InterpreterContext context, IProgram program) throws IOException {
        this.channels = context.getChannels();
        this.rootBehavior = program.getEventCount() == 0 ? null : new RootBehaviorImpl(context, program);
        for (IBehavior behavior : program.getBehaviorList()) {
            BehaviorImpl behaviorImpl = context.createBehavior(behavior);
            this.behaviors.add(behaviorImpl);
            context.getLua().set(behavior.getName(), (int)behaviorImpl.id);
        }
    }

    public RootBehaviorImpl getRootBehavior() {
        return this.rootBehavior;
    }

    @Override
    public void collectBehaviors(List<Behavior> result) {
        if (this.rootBehavior != null) {
            result.add(this.rootBehavior);
        }
        result.addAll(this.behaviors);
    }

    @Override
    public void collectChannels(List<Channel> result) {
        for (Channel channel : this.channels) {
            result.add(channel);
        }
    }
}

